/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.util.List;
import net.nmoncho.shaded.com.google.common.collect.Ordering;

public abstract class AsymmetricOrdering<T1, T2>
extends Ordering<T1> {
    public abstract int compareAsymmetric(T1 var1, T2 var2);

    public int binarySearchAsymmetric(List<? extends T1> searchIn, T2 searchFor, Op op) {
        int strictnessOfLessThan = AsymmetricOrdering.strictnessOfLessThan(op);
        int lb = -1;
        int ub = searchIn.size();
        while (lb + 1 < ub) {
            int m = (lb + ub) / 2;
            int c = this.compareAsymmetric(searchIn.get(m), searchFor);
            if (c < strictnessOfLessThan) {
                lb = m;
                continue;
            }
            ub = m;
        }
        return AsymmetricOrdering.selectBoundary(op, lb, ub);
    }

    private static int strictnessOfLessThan(Op op) {
        switch (op) {
            case FLOOR: 
            case HIGHER: {
                return 1;
            }
            case CEIL: 
            case LOWER: {
                return 0;
            }
        }
        throw new IllegalStateException();
    }

    private static int selectBoundary(Op op, int lb, int ub) {
        switch (op) {
            case HIGHER: 
            case CEIL: {
                return ub;
            }
            case FLOOR: 
            case LOWER: {
                return lb;
            }
        }
        throw new IllegalStateException();
    }

    public AsymmetricOrdering<T1, T2> reverse() {
        return new Reversed();
    }

    private class Reversed
    extends AsymmetricOrdering<T1, T2> {
        private Reversed() {
        }

        @Override
        public int compareAsymmetric(T1 left, T2 right) {
            return -AsymmetricOrdering.this.compareAsymmetric(left, right);
        }

        @Override
        public int compare(T1 left, T1 right) {
            return AsymmetricOrdering.this.compare(right, left);
        }

        @Override
        public AsymmetricOrdering<T1, T2> reverse() {
            return AsymmetricOrdering.this;
        }
    }

    public static enum Op {
        LOWER,
        FLOOR,
        CEIL,
        HIGHER;

    }
}

