/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.transport;

import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import net.nmoncho.shaded.com.google.common.base.Joiner;
import net.nmoncho.shaded.com.google.common.collect.ImmutableMap;
import net.nmoncho.shaded.io.netty.handler.ssl.SslHandler;
import org.apache.cassandra.auth.AuthenticatedUser;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.transport.ConnectionStage;
import org.apache.cassandra.transport.ServerConnection;

public final class ConnectedClient {
    public static final String ADDRESS = "address";
    public static final String USER = "user";
    public static final String VERSION = "version";
    public static final String CLIENT_OPTIONS = "clientOptions";
    public static final String DRIVER_NAME = "driverName";
    public static final String DRIVER_VERSION = "driverVersion";
    public static final String REQUESTS = "requests";
    public static final String KEYSPACE = "keyspace";
    public static final String SSL = "ssl";
    public static final String CIPHER = "cipher";
    public static final String PROTOCOL = "protocol";
    private static final String UNDEFINED = "undefined";
    private final ServerConnection connection;

    ConnectedClient(ServerConnection connection) {
        this.connection = connection;
    }

    public ConnectionStage stage() {
        return this.connection.stage();
    }

    public InetSocketAddress remoteAddress() {
        return this.state().getRemoteAddress();
    }

    public Optional<String> username() {
        AuthenticatedUser user = this.state().getUser();
        return null != user ? Optional.of(user.getName()) : Optional.empty();
    }

    public int protocolVersion() {
        return this.connection.getVersion().asInt();
    }

    public Optional<String> driverName() {
        return this.state().getDriverName();
    }

    public Optional<String> driverVersion() {
        return this.state().getDriverVersion();
    }

    public Optional<Map<String, String>> clientOptions() {
        return this.state().getClientOptions();
    }

    public long requestCount() {
        return this.connection.requests.getCount();
    }

    public Optional<String> keyspace() {
        return Optional.ofNullable(this.state().getRawKeyspace());
    }

    public boolean sslEnabled() {
        return null != this.sslHandler();
    }

    public Optional<String> sslCipherSuite() {
        SslHandler sslHandler = this.sslHandler();
        return null != sslHandler ? Optional.of(sslHandler.engine().getSession().getCipherSuite()) : Optional.empty();
    }

    public Optional<String> sslProtocol() {
        SslHandler sslHandler = this.sslHandler();
        return null != sslHandler ? Optional.of(sslHandler.engine().getSession().getProtocol()) : Optional.empty();
    }

    private ClientState state() {
        return this.connection.getClientState();
    }

    private SslHandler sslHandler() {
        return (SslHandler)this.connection.channel().pipeline().get(SslHandler.class);
    }

    public Map<String, String> asMap() {
        return ImmutableMap.builder().put(ADDRESS, this.remoteAddress().toString()).put(USER, this.username().orElse(UNDEFINED)).put(VERSION, String.valueOf(this.protocolVersion())).put(CLIENT_OPTIONS, Joiner.on(", ").withKeyValueSeparator("=").join(this.clientOptions().orElse(Collections.emptyMap()))).put(DRIVER_NAME, this.driverName().orElse(UNDEFINED)).put(DRIVER_VERSION, this.driverVersion().orElse(UNDEFINED)).put(REQUESTS, String.valueOf(this.requestCount())).put(KEYSPACE, this.keyspace().orElse("")).put(SSL, Boolean.toString(this.sslEnabled())).put(CIPHER, this.sslCipherSuite().orElse(UNDEFINED)).put(PROTOCOL, this.sslProtocol().orElse(UNDEFINED)).build();
    }
}

