/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.transport;

import java.io.IOException;
import net.jpountz.lz4.LZ4Decompressor;
import net.jpountz.lz4.LZ4Factory;
import net.nmoncho.shaded.io.netty.buffer.ByteBuf;
import org.apache.cassandra.transport.CBUtil;
import org.apache.cassandra.transport.Envelope;
import org.apache.cassandra.transport.ProtocolException;
import org.apache.cassandra.utils.JVMStabilityInspector;
import org.xerial.snappy.Snappy;
import org.xerial.snappy.SnappyError;

public interface Compressor {
    public Envelope compress(Envelope var1) throws IOException;

    public Envelope decompress(Envelope var1) throws IOException;

    public static class LZ4Compressor
    implements Compressor {
        public static final LZ4Compressor instance = new LZ4Compressor();
        private static final int INTEGER_BYTES = 4;
        private final net.jpountz.lz4.LZ4Compressor compressor;
        private final LZ4Decompressor decompressor;

        private LZ4Compressor() {
            LZ4Factory lz4Factory = LZ4Factory.fastestInstance();
            this.compressor = lz4Factory.fastCompressor();
            this.decompressor = lz4Factory.decompressor();
        }

        @Override
        public Envelope compress(Envelope uncompressed) {
            byte[] input = CBUtil.readRawBytes(uncompressed.body);
            int maxCompressedLength = this.compressor.maxCompressedLength(input.length);
            ByteBuf outputBuf = CBUtil.allocator.heapBuffer(4 + maxCompressedLength);
            byte[] output = outputBuf.array();
            int outputOffset = outputBuf.arrayOffset();
            output[outputOffset] = (byte)(input.length >>> 24);
            output[outputOffset + 1] = (byte)(input.length >>> 16);
            output[outputOffset + 2] = (byte)(input.length >>> 8);
            output[outputOffset + 3] = (byte)input.length;
            try {
                int written = this.compressor.compress(input, 0, input.length, output, outputOffset + 4, maxCompressedLength);
                outputBuf.writerIndex(4 + written);
                Envelope envelope = uncompressed.with(outputBuf);
                return envelope;
            }
            catch (Throwable e) {
                outputBuf.release();
                throw e;
            }
            finally {
                uncompressed.release();
            }
        }

        @Override
        public Envelope decompress(Envelope compressed) throws IOException {
            byte[] input = CBUtil.readRawBytes(compressed.body);
            int uncompressedLength = (input[0] & 0xFF) << 24 | (input[1] & 0xFF) << 16 | (input[2] & 0xFF) << 8 | input[3] & 0xFF;
            ByteBuf output = CBUtil.allocator.heapBuffer(uncompressedLength);
            try {
                int read = this.decompressor.decompress(input, 4, output.array(), output.arrayOffset(), uncompressedLength);
                if (read != input.length - 4) {
                    throw new IOException("Compressed lengths mismatch");
                }
                output.writerIndex(uncompressedLength);
                Envelope envelope = compressed.with(output);
                return envelope;
            }
            catch (Throwable e) {
                output.release();
                throw e;
            }
            finally {
                compressed.release();
            }
        }
    }

    public static class SnappyCompressor
    implements Compressor {
        public static final SnappyCompressor instance;

        private SnappyCompressor() {
            Snappy.getNativeLibraryVersion();
        }

        @Override
        public Envelope compress(Envelope uncompressed) throws IOException {
            byte[] input = CBUtil.readRawBytes(uncompressed.body);
            ByteBuf output = CBUtil.allocator.heapBuffer(Snappy.maxCompressedLength((int)input.length));
            try {
                int written = Snappy.compress((byte[])input, (int)0, (int)input.length, (byte[])output.array(), (int)output.arrayOffset());
                output.writerIndex(written);
            }
            catch (Throwable e) {
                output.release();
                throw e;
            }
            finally {
                uncompressed.release();
            }
            return uncompressed.with(output);
        }

        @Override
        public Envelope decompress(Envelope compressed) throws IOException {
            byte[] input = CBUtil.readRawBytes(compressed.body);
            if (!Snappy.isValidCompressedBuffer((byte[])input, (int)0, (int)input.length)) {
                throw new ProtocolException("Provided frame does not appear to be Snappy compressed");
            }
            ByteBuf output = CBUtil.allocator.heapBuffer(Snappy.uncompressedLength((byte[])input));
            try {
                int size = Snappy.uncompress((byte[])input, (int)0, (int)input.length, (byte[])output.array(), (int)output.arrayOffset());
                output.writerIndex(size);
            }
            catch (Throwable e) {
                output.release();
                throw e;
            }
            finally {
                compressed.release();
            }
            return compressed.with(output);
        }

        static {
            SnappyCompressor i;
            try {
                i = new SnappyCompressor();
            }
            catch (Exception e) {
                JVMStabilityInspector.inspectThrowable(e);
                i = null;
            }
            catch (NoClassDefFoundError | UnsatisfiedLinkError | SnappyError e) {
                i = null;
            }
            instance = i;
        }
    }
}

