/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool.stats;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.nmoncho.shaded.com.google.common.base.Throwables;
import org.apache.cassandra.db.ColumnFamilyStoreMBean;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.cassandra.tools.nodetool.stats.StatsHolder;

public class DataPathsHolder
implements StatsHolder {
    public final Map<String, Object> pathsHash = new HashMap<String, Object>();

    public DataPathsHolder(NodeProbe probe, List<String> tableNames) {
        Iterator<Map.Entry<String, ColumnFamilyStoreMBean>> mbeansIterator = probe.getColumnFamilyStoreMBeanProxies();
        while (mbeansIterator.hasNext()) {
            Map<String, List<String>> ksPaths;
            List<String> dataPaths;
            Map.Entry<String, ColumnFamilyStoreMBean> entry = mbeansIterator.next();
            String keyspaceName = entry.getKey();
            String tableName = entry.getValue().getTableName();
            if (!tableNames.isEmpty() && !tableNames.contains(keyspaceName + '.' + tableName) && !tableNames.contains(keyspaceName)) continue;
            try {
                dataPaths = entry.getValue().getDataPaths();
            }
            catch (Throwable e) {
                probe.output().err.println("Failed to get data paths for " + keyspaceName + '.' + tableName + ". Skipped.");
                probe.output().err.println("error: " + e.getMessage());
                probe.output().err.println("-- StackTrace --");
                probe.output().err.println(Throwables.getStackTraceAsString(e));
                continue;
            }
            if (this.pathsHash.containsKey(keyspaceName)) {
                ksPaths = (Map)this.pathsHash.get(keyspaceName);
            } else {
                ksPaths = new HashMap();
                this.pathsHash.put(keyspaceName, ksPaths);
            }
            ksPaths.put(tableName, dataPaths);
        }
    }

    @Override
    public Map<String, Object> convert2Map() {
        return this.pathsHash;
    }
}

