/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool.stats;

import java.io.PrintStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.nmoncho.shaded.com.google.common.collect.Iterables;
import org.apache.cassandra.tools.nodetool.formatter.TableBuilder;
import org.apache.cassandra.tools.nodetool.stats.CompactionHistoryHolder;
import org.apache.cassandra.tools.nodetool.stats.StatsPrinter;

public class CompactionHistoryPrinter {
    public static StatsPrinter from(String format) {
        switch (format) {
            case "json": {
                return new StatsPrinter.JsonPrinter();
            }
            case "yaml": {
                return new StatsPrinter.YamlPrinter();
            }
        }
        return new DefaultPrinter();
    }

    public static class DefaultPrinter
    implements StatsPrinter<CompactionHistoryHolder> {
        @Override
        public void print(CompactionHistoryHolder data, PrintStream out) {
            out.println("Compaction History: ");
            Map<String, Object> convertData = data.convert2Map();
            List compactionHistories = convertData.get("CompactionHistory") instanceof List ? (List)convertData.get("CompactionHistory") : Collections.emptyList();
            List<String> indexNames = data.indexNames;
            if (compactionHistories.size() == 0) {
                out.printf("There is no compaction history", new Object[0]);
                return;
            }
            TableBuilder table = new TableBuilder();
            table.add(Iterables.toArray(indexNames, String.class));
            for (Object chr : compactionHistories) {
                Map value = chr instanceof Map ? (Map)chr : Collections.emptyMap();
                String[] obj = new String[]{(String)value.get("id"), (String)value.get("keyspace_name"), (String)value.get("columnfamily_name"), (String)value.get("compacted_at"), value.get("bytes_in").toString(), value.get("bytes_out").toString(), (String)value.get("rows_merged")};
                table.add(obj);
            }
            table.printTo(out);
        }
    }
}

