/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool;

import io.airlift.airline.Arguments;
import io.airlift.airline.Command;
import java.util.ArrayList;
import java.util.List;
import net.nmoncho.shaded.com.google.common.base.Preconditions;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.cassandra.tools.NodeTool;

@Command(name="gettimeout", description="Print the timeout of the given type in ms")
public class GetTimeout
extends NodeTool.NodeToolCmd {
    public static final String TIMEOUT_TYPES = "read, range, write, counterwrite, cascontention, truncate, internodeconnect, internodeuser, internodestreaminguser, misc (general rpc_timeout_in_ms)";
    @Arguments(usage="<timeout_type>", description="The timeout type, one of (read, range, write, counterwrite, cascontention, truncate, internodeconnect, internodeuser, internodestreaminguser, misc (general rpc_timeout_in_ms))")
    private List<String> args = new ArrayList<String>();

    @Override
    public void execute(NodeProbe probe) {
        Preconditions.checkArgument(this.args.size() == 1, "gettimeout requires a timeout type, one of (read, range, write, counterwrite, cascontention, truncate, internodeconnect, internodeuser, internodestreaminguser, misc (general rpc_timeout_in_ms))");
        try {
            probe.output().out.println("Current timeout for type " + this.args.get(0) + ": " + probe.getTimeout(this.args.get(0)) + " ms");
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }
}

