/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool;

import io.airlift.airline.Command;
import io.airlift.airline.Option;
import net.nmoncho.shaded.com.google.common.math.DoubleMath;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.cassandra.tools.NodeTool;

@Command(name="getcompactionthroughput", description="Print the MiB/s throughput cap for compaction in the system as a rounded number")
public class GetCompactionThroughput
extends NodeTool.NodeToolCmd {
    @Option(name={"-d", "--precise-mib"}, description="Print the MiB/s throughput cap for compaction in the system as a precise number (double)")
    private boolean compactionThroughputAsDouble;

    @Override
    public void execute(NodeProbe probe) {
        double throughput = probe.getCompactionThroughputMebibytesAsDouble();
        if (this.compactionThroughputAsDouble) {
            probe.output().out.println("Current compaction throughput: " + throughput + " MiB/s");
        } else {
            if (!DoubleMath.isMathematicalInteger(throughput)) {
                throw new RuntimeException("Use the -d flag to quiet this error and get the exact throughput in MiB/s");
            }
            probe.output().out.println("Current compaction throughput: " + probe.getCompactionThroughput() + " MB/s");
        }
    }
}

