/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming.messages;

import java.io.IOException;
import net.nmoncho.shaded.com.google.common.base.Objects;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.schema.TableId;
import org.apache.cassandra.streaming.StreamSession;
import org.apache.cassandra.utils.TimeUUID;

public class StreamMessageHeader {
    public static FileMessageHeaderSerializer serializer = new FileMessageHeaderSerializer();
    public final TableId tableId;
    public TimeUUID planId;
    public final boolean sendByFollower;
    public int sessionIndex;
    public final int sequenceNumber;
    public final long repairedAt;
    public final TimeUUID pendingRepair;
    public final InetAddressAndPort sender;

    public StreamMessageHeader(TableId tableId, InetAddressAndPort sender, TimeUUID planId, boolean sendByFollower, int sessionIndex, int sequenceNumber, long repairedAt, TimeUUID pendingRepair) {
        this.tableId = tableId;
        this.sender = sender;
        this.planId = planId;
        this.sendByFollower = sendByFollower;
        this.sessionIndex = sessionIndex;
        this.sequenceNumber = sequenceNumber;
        this.repairedAt = repairedAt;
        this.pendingRepair = pendingRepair;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Header (");
        sb.append("tableId: ").append(this.tableId);
        sb.append(", #").append(this.sequenceNumber);
        sb.append(", repairedAt: ").append(this.repairedAt);
        sb.append(", pendingRepair: ").append(this.pendingRepair);
        sb.append(", sendByFollower: ").append(this.sendByFollower);
        sb.append(')');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StreamMessageHeader that = (StreamMessageHeader)o;
        return this.sendByFollower == that.sendByFollower && this.sequenceNumber == that.sequenceNumber && Objects.equal(this.tableId, that.tableId);
    }

    public int hashCode() {
        return Objects.hashCode(this.tableId, this.sendByFollower, this.sequenceNumber);
    }

    public void addSessionInfo(StreamSession session) {
        this.planId = session.planId();
        this.sessionIndex = session.sessionIndex();
    }

    public static class FileMessageHeaderSerializer {
        public void serialize(StreamMessageHeader header, DataOutputPlus out, int version) throws IOException {
            header.tableId.serialize(out);
            InetAddressAndPort.Serializer.inetAddressAndPortSerializer.serialize(header.sender, out, version);
            header.planId.serialize(out);
            out.writeBoolean(header.sendByFollower);
            out.writeInt(header.sessionIndex);
            out.writeInt(header.sequenceNumber);
            out.writeLong(header.repairedAt);
            out.writeBoolean(header.pendingRepair != null);
            if (header.pendingRepair != null) {
                header.pendingRepair.serialize(out);
            }
        }

        public StreamMessageHeader deserialize(DataInputPlus in, int version) throws IOException {
            TableId tableId = TableId.deserialize(in);
            InetAddressAndPort sender = InetAddressAndPort.Serializer.inetAddressAndPortSerializer.deserialize(in, version);
            TimeUUID planId = TimeUUID.deserialize(in);
            boolean sendByFollower = in.readBoolean();
            int sessionIndex = in.readInt();
            int sequenceNumber = in.readInt();
            long repairedAt = in.readLong();
            TimeUUID pendingRepair = in.readBoolean() ? TimeUUID.deserialize(in) : null;
            return new StreamMessageHeader(tableId, sender, planId, sendByFollower, sessionIndex, sequenceNumber, repairedAt, pendingRepair);
        }

        public long serializedSize(StreamMessageHeader header, int version) {
            long size = header.tableId.serializedSize();
            size += InetAddressAndPort.Serializer.inetAddressAndPortSerializer.serializedSize(header.sender, version);
            size += TimeUUID.sizeInBytes();
            size += (long)TypeSizes.sizeof(header.sendByFollower);
            size += (long)TypeSizes.sizeof(header.sessionIndex);
            size += (long)TypeSizes.sizeof(header.sequenceNumber);
            size += (long)TypeSizes.sizeof(header.repairedAt);
            size += (long)TypeSizes.sizeof(header.pendingRepair != null);
            return size += header.pendingRepair != null ? TimeUUID.sizeInBytes() : 0L;
        }
    }
}

