/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.function.IntFunction;
import net.nmoncho.shaded.io.netty.util.concurrent.Future;
import org.apache.cassandra.streaming.StreamingDataInputPlus;
import org.apache.cassandra.streaming.StreamingDataOutputPlus;
import org.apache.cassandra.streaming.async.NettyStreamingConnectionFactory;
import org.apache.cassandra.utils.Shared;

@Shared(scope={Shared.Scope.SIMULATION}, inner=Shared.Recursive.INTERFACES)
public interface StreamingChannel {
    public Object id();

    public String description();

    public InetSocketAddress peer();

    public InetSocketAddress connectedTo();

    public boolean connected();

    public StreamingDataInputPlus in();

    public StreamingDataOutputPlus acquireOut();

    public Future<?> send(Send var1) throws IOException;

    public Future<?> close();

    public void onClose(Runnable var1);

    public static interface Send {
        public void send(IntFunction<StreamingDataOutputPlus> var1) throws IOException;
    }

    public static enum Kind {
        CONTROL,
        FILE;

    }

    public static interface Factory {
        public StreamingChannel create(InetSocketAddress var1, int var2, Kind var3) throws IOException;

        default public StreamingChannel create(InetSocketAddress to, InetSocketAddress preferred, int messagingVersion, Kind kind) throws IOException {
            return this.create(to, messagingVersion, kind);
        }

        default public boolean supportsPreferredIp() {
            return true;
        }

        public static class Global {
            private static Factory FACTORY = new NettyStreamingConnectionFactory();

            public static Factory streamingFactory() {
                return FACTORY;
            }

            public static void unsafeSet(Factory factory) {
                FACTORY = factory;
            }
        }
    }
}

