/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming;

import java.io.IOException;
import java.io.Serializable;
import net.nmoncho.shaded.com.google.common.base.Objects;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.schema.TableId;

public class StreamSummary
implements Serializable {
    public static final IVersionedSerializer<StreamSummary> serializer = new StreamSummarySerializer();
    public final TableId tableId;
    public final int files;
    public final long totalSize;

    public StreamSummary(TableId tableId, int files, long totalSize) {
        this.tableId = tableId;
        this.files = files;
        this.totalSize = totalSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StreamSummary summary = (StreamSummary)o;
        return this.files == summary.files && this.totalSize == summary.totalSize && this.tableId.equals(summary.tableId);
    }

    public int hashCode() {
        return Objects.hashCode(this.tableId, this.files, this.totalSize);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("StreamSummary{");
        sb.append("path=").append(this.tableId);
        sb.append(", files=").append(this.files);
        sb.append(", totalSize=").append(this.totalSize);
        sb.append('}');
        return sb.toString();
    }

    public static class StreamSummarySerializer
    implements IVersionedSerializer<StreamSummary> {
        @Override
        public void serialize(StreamSummary summary, DataOutputPlus out, int version) throws IOException {
            summary.tableId.serialize(out);
            out.writeInt(summary.files);
            out.writeLong(summary.totalSize);
        }

        @Override
        public StreamSummary deserialize(DataInputPlus in, int version) throws IOException {
            TableId tableId = TableId.deserialize(in);
            int files = in.readInt();
            long totalSize = in.readLong();
            return new StreamSummary(tableId, files, totalSize);
        }

        @Override
        public long serializedSize(StreamSummary summary, int version) {
            long size = summary.tableId.serializedSize();
            size += (long)TypeSizes.sizeof(summary.files);
            return size += (long)TypeSizes.sizeof(summary.totalSize);
        }
    }
}

