/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming;

import java.io.Serializable;
import java.util.List;
import java.util.Set;
import net.nmoncho.shaded.com.google.common.collect.Iterables;
import net.nmoncho.shaded.com.google.common.collect.Lists;
import org.apache.cassandra.streaming.SessionInfo;
import org.apache.cassandra.streaming.SessionSummary;
import org.apache.cassandra.streaming.StreamOperation;
import org.apache.cassandra.utils.TimeUUID;

public class StreamState
implements Serializable {
    public final TimeUUID planId;
    public final StreamOperation streamOperation;
    public final Set<SessionInfo> sessions;

    public StreamState(TimeUUID planId, StreamOperation streamOperation, Set<SessionInfo> sessions) {
        this.planId = planId;
        this.sessions = sessions;
        this.streamOperation = streamOperation;
    }

    public boolean hasFailedSession() {
        return Iterables.any(this.sessions, SessionInfo::isFailed);
    }

    public boolean hasAbortedSession() {
        return Iterables.any(this.sessions, SessionInfo::isAborted);
    }

    public List<SessionSummary> createSummaries() {
        return Lists.newArrayList(Iterables.transform(this.sessions, SessionInfo::createSummary));
    }
}

