/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.reads.repair;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.nmoncho.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.diag.DiagnosticEvent;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.service.reads.DigestResolver;
import org.apache.cassandra.service.reads.SpeculativeRetryPolicy;
import org.apache.cassandra.service.reads.repair.AbstractReadRepair;

final class ReadRepairEvent
extends DiagnosticEvent {
    private final ReadRepairEventType type;
    private final Keyspace keyspace;
    private final String tableName;
    private final String cqlCommand;
    private final ConsistencyLevel consistency;
    private final SpeculativeRetryPolicy.Kind speculativeRetry;
    @VisibleForTesting
    final Collection<InetAddressAndPort> destinations;
    @VisibleForTesting
    final Collection<InetAddressAndPort> allEndpoints;
    @Nullable
    private final DigestResolver.DigestResolverDebugResult[] digestsByEndpoint;

    ReadRepairEvent(ReadRepairEventType type, AbstractReadRepair readRepair, Collection<InetAddressAndPort> destinations, Collection<InetAddressAndPort> allEndpoints, DigestResolver digestResolver) {
        this.keyspace = readRepair.cfs.keyspace;
        this.tableName = readRepair.cfs.getTableName();
        this.cqlCommand = readRepair.command.toCQLString();
        this.consistency = readRepair.replicaPlan().consistencyLevel();
        this.speculativeRetry = readRepair.cfs.metadata().params.speculativeRetry.kind();
        this.destinations = destinations;
        this.allEndpoints = allEndpoints;
        this.digestsByEndpoint = digestResolver != null ? digestResolver.getDigestsByEndpoint() : null;
        this.type = type;
    }

    public ReadRepairEventType getType() {
        return this.type;
    }

    @Override
    public Map<String, Serializable> toMap() {
        HashMap<String, Serializable> ret = new HashMap<String, Serializable>();
        ret.put("keyspace", (Serializable)((Object)this.keyspace.getName()));
        ret.put("table", (Serializable)((Object)this.tableName));
        ret.put("command", (Serializable)((Object)this.cqlCommand));
        ret.put("consistency", (Serializable)((Object)this.consistency.name()));
        ret.put("speculativeRetry", (Serializable)((Object)this.speculativeRetry.name()));
        Set eps = this.destinations.stream().map(Object::toString).collect(Collectors.toSet());
        ret.put("endpointDestinations", new HashSet(eps));
        if (this.digestsByEndpoint != null) {
            HashMap digestsMap = new HashMap();
            for (DigestResolver.DigestResolverDebugResult digestsByEndpoint : this.digestsByEndpoint) {
                HashMap<String, Object> digests = new HashMap<String, Object>();
                digests.put("digestHex", digestsByEndpoint.digestHex);
                digests.put("isDigestResponse", digestsByEndpoint.isDigestResponse);
                digestsMap.put(digestsByEndpoint.from.toString(), digests);
            }
            ret.put("digestsByEndpoint", digestsMap);
        }
        if (this.allEndpoints != null) {
            eps = this.allEndpoints.stream().map(Object::toString).collect(Collectors.toSet());
            ret.put("allEndpoints", new HashSet(eps));
        }
        return ret;
    }

    static enum ReadRepairEventType {
        START_REPAIR,
        SPECULATED_READ;

    }
}

