/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.reads.repair;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.nmoncho.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.diag.DiagnosticEvent;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.service.reads.repair.BlockingPartitionRepair;
import org.apache.cassandra.utils.ByteBufferUtil;

final class PartitionRepairEvent
extends DiagnosticEvent {
    private final PartitionRepairEventType type;
    @VisibleForTesting
    final InetAddressAndPort destination;
    @Nullable
    private final Keyspace keyspace;
    @Nullable
    private final DecoratedKey key;
    @Nullable
    private final ConsistencyLevel consistency;
    @Nullable
    @VisibleForTesting
    String mutationSummary;

    PartitionRepairEvent(PartitionRepairEventType type, BlockingPartitionRepair partitionRepair, InetAddressAndPort destination, Mutation mutation) {
        this.type = type;
        this.destination = destination;
        this.keyspace = partitionRepair.getKeyspace();
        this.consistency = partitionRepair.getConsistency();
        this.key = partitionRepair.getKey();
        if (mutation != null) {
            try {
                this.mutationSummary = mutation.toString();
            }
            catch (Exception e) {
                this.mutationSummary = String.format("<Mutation.toString(): %s>", e.getMessage());
            }
        }
    }

    public PartitionRepairEventType getType() {
        return this.type;
    }

    @Override
    public Map<String, Serializable> toMap() {
        HashMap<String, Serializable> ret = new HashMap<String, Serializable>();
        if (this.keyspace != null) {
            ret.put("keyspace", (Serializable)((Object)this.keyspace.getName()));
        }
        if (this.key != null) {
            ret.put("key", (Serializable)((Object)(this.key.getKey() == null ? "null" : ByteBufferUtil.bytesToHex(this.key.getKey()))));
            ret.put("token", (Serializable)((Object)this.key.getToken().toString()));
        }
        if (this.consistency != null) {
            ret.put("consistency", (Serializable)((Object)this.consistency.name()));
        }
        ret.put("destination", (Serializable)((Object)this.destination.toString()));
        if (this.mutationSummary != null) {
            ret.put("mutation", (Serializable)((Object)this.mutationSummary));
        }
        return ret;
    }

    static enum PartitionRepairEventType {
        SEND_INITIAL_REPAIRS,
        SPECULATED_WRITE,
        UPDATE_OVERSIZED;

    }
}

