/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.reads.range;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.nmoncho.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.Bounds;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.locator.LocalStrategy;
import org.apache.cassandra.locator.ReplicaPlan;
import org.apache.cassandra.locator.ReplicaPlans;
import org.apache.cassandra.locator.TokenMetadata;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.AbstractIterator;
import org.apache.cassandra.utils.Pair;

class ReplicaPlanIterator
extends AbstractIterator<ReplicaPlan.ForRangeRead> {
    private final Keyspace keyspace;
    private final ConsistencyLevel consistency;
    @VisibleForTesting
    final Iterator<? extends AbstractBounds<PartitionPosition>> ranges;
    private final int rangeCount;

    ReplicaPlanIterator(AbstractBounds<PartitionPosition> keyRange, Keyspace keyspace, ConsistencyLevel consistency) {
        this.keyspace = keyspace;
        this.consistency = consistency;
        List<AbstractBounds<PartitionPosition>> l = keyspace.getReplicationStrategy() instanceof LocalStrategy ? keyRange.unwrap() : ReplicaPlanIterator.getRestrictedRanges(keyRange);
        this.ranges = l.iterator();
        this.rangeCount = l.size();
    }

    int size() {
        return this.rangeCount;
    }

    @Override
    protected ReplicaPlan.ForRangeRead computeNext() {
        if (!this.ranges.hasNext()) {
            return (ReplicaPlan.ForRangeRead)this.endOfData();
        }
        return ReplicaPlans.forRangeRead(this.keyspace, this.consistency, this.ranges.next(), 1);
    }

    private static List<AbstractBounds<PartitionPosition>> getRestrictedRanges(AbstractBounds<PartitionPosition> queryRange) {
        Token upperBoundToken;
        Token.KeyBound upperBound;
        if (queryRange instanceof Bounds && ((PartitionPosition)queryRange.left).equals(queryRange.right) && !((PartitionPosition)queryRange.left).isMinimum()) {
            return Collections.singletonList(queryRange);
        }
        TokenMetadata tokenMetadata = StorageService.instance.getTokenMetadata();
        ArrayList<AbstractBounds<PartitionPosition>> ranges = new ArrayList<AbstractBounds<PartitionPosition>>();
        Iterator<Token> ringIter = TokenMetadata.ringIterator(tokenMetadata.sortedTokens(), ((PartitionPosition)queryRange.left).getToken(), true);
        AbstractBounds remainder = queryRange;
        while (ringIter.hasNext() && (((PartitionPosition)remainder.left).equals(upperBound = (upperBoundToken = ringIter.next()).maxKeyBound()) || remainder.contains((PartitionPosition)upperBound))) {
            Pair<AbstractBounds<PartitionPosition>, AbstractBounds<PartitionPosition>> splits = remainder.split((PartitionPosition)upperBound);
            if (splits == null) continue;
            ranges.add((AbstractBounds<PartitionPosition>)splits.left);
            remainder = (AbstractBounds)splits.right;
        }
        ranges.add(remainder);
        return ranges;
    }
}

