/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.reads;

import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.nmoncho.shaded.com.google.common.base.Objects;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.metrics.SnapshottingTimer;
import org.apache.cassandra.schema.TableParams;
import org.apache.cassandra.service.reads.SpeculativeRetryPolicy;

public class FixedSpeculativeRetryPolicy
implements SpeculativeRetryPolicy {
    private static final Pattern PATTERN = Pattern.compile("^(?<val>[0-9.]+)ms$", 2);
    private final int speculateAtMilliseconds;

    FixedSpeculativeRetryPolicy(int speculateAtMilliseconds) {
        this.speculateAtMilliseconds = speculateAtMilliseconds;
    }

    @Override
    public long calculateThreshold(SnapshottingTimer latency, long existingValue) {
        return TimeUnit.MILLISECONDS.toMicros(this.speculateAtMilliseconds);
    }

    @Override
    public SpeculativeRetryPolicy.Kind kind() {
        return SpeculativeRetryPolicy.Kind.FIXED;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FixedSpeculativeRetryPolicy)) {
            return false;
        }
        FixedSpeculativeRetryPolicy rhs = (FixedSpeculativeRetryPolicy)obj;
        return this.speculateAtMilliseconds == rhs.speculateAtMilliseconds;
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.kind(), this.speculateAtMilliseconds});
    }

    public String toString() {
        return String.format("%dms", this.speculateAtMilliseconds);
    }

    static FixedSpeculativeRetryPolicy fromString(String str) {
        Matcher matcher = PATTERN.matcher(str);
        if (!matcher.matches()) {
            throw new IllegalArgumentException();
        }
        String val = matcher.group("val");
        try {
            return new FixedSpeculativeRetryPolicy((int)Double.parseDouble(val));
        }
        catch (IllegalArgumentException e) {
            throw new ConfigurationException(String.format("Invalid value %s for option '%s'", new Object[]{str, TableParams.Option.SPECULATIVE_RETRY}));
        }
    }

    static boolean stringMatches(String str) {
        return PATTERN.matcher(str).matches();
    }
}

