/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.paxos.uncommitted;

import java.io.IOException;
import java.nio.file.Files;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.nmoncho.shaded.com.google.common.annotations.VisibleForTesting;
import net.nmoncho.shaded.com.google.common.base.Preconditions;
import net.nmoncho.shaded.com.google.common.collect.Iterables;
import net.nmoncho.shaded.com.google.common.collect.PeekingIterator;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.FSReadError;
import org.apache.cassandra.io.util.ChecksummedRandomAccessReader;
import org.apache.cassandra.io.util.ChecksummedSequentialWriter;
import org.apache.cassandra.io.util.File;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.io.util.SequentialWriter;
import org.apache.cassandra.io.util.SequentialWriterOption;
import org.apache.cassandra.schema.TableId;
import org.apache.cassandra.service.paxos.Ballot;
import org.apache.cassandra.service.paxos.uncommitted.PaxosKeyState;
import org.apache.cassandra.utils.AbstractIterator;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.CloseableIterator;
import org.apache.cassandra.utils.Throwables;

public class UncommittedDataFile {
    static final String EXTENSION = "paxos";
    static final String TMP_SUFFIX = ".tmp";
    private static final int VERSION = 0;
    final TableId tableId;
    private final File file;
    private final File crcFile;
    private final long generation;
    private int activeReaders = 0;
    private boolean markedDeleted = false;

    private UncommittedDataFile(TableId tableId, File file, File crcFile, long generation) {
        this.tableId = tableId;
        this.file = file;
        this.crcFile = crcFile;
        this.generation = generation;
    }

    public static UncommittedDataFile create(TableId tableId, File file, File crcFile, long generation) {
        return new UncommittedDataFile(tableId, file, crcFile, generation);
    }

    static Writer writer(File directory, String keyspace, String table, TableId tableId, long generation) throws IOException {
        return new Writer(directory, keyspace, table, tableId, generation);
    }

    static Set<TableId> listTableIds(File directory) {
        Pattern pattern = Pattern.compile(".*-([a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12})-(\\d+)\\.paxos$");
        HashSet<TableId> tableIds = new HashSet<TableId>();
        for (String fname : directory.listNamesUnchecked()) {
            Matcher matcher = pattern.matcher(fname);
            if (!matcher.matches()) continue;
            tableIds.add(TableId.fromUUID(UUID.fromString(matcher.group(1))));
        }
        return tableIds;
    }

    static Pattern fileRegexFor(TableId tableId) {
        return Pattern.compile(".*-" + tableId.toString() + "-(\\d+)\\." + EXTENSION + ".*");
    }

    static boolean isTmpFile(String fname) {
        return fname.endsWith(TMP_SUFFIX);
    }

    static boolean isCrcFile(String fname) {
        return fname.endsWith(".crc");
    }

    static String fileName(String keyspace, String table, TableId tableId, long generation) {
        return String.format("%s-%s-%s-%s.%s", keyspace, table, tableId, generation, EXTENSION);
    }

    static String crcName(String fname) {
        return fname + ".crc";
    }

    synchronized void markDeleted() {
        this.markedDeleted = true;
        this.maybeDelete();
    }

    private void maybeDelete() {
        if (this.markedDeleted && this.activeReaders == 0) {
            this.file.delete();
            this.crcFile.delete();
        }
    }

    private synchronized void onIteratorClose() {
        --this.activeReaders;
        this.maybeDelete();
    }

    @VisibleForTesting
    File file() {
        return this.file;
    }

    @VisibleForTesting
    int getActiveReaders() {
        return this.activeReaders;
    }

    @VisibleForTesting
    boolean isMarkedDeleted() {
        return this.markedDeleted;
    }

    long generation() {
        return this.generation;
    }

    synchronized CloseableIterator<PaxosKeyState> iterator(Collection<Range<Token>> ranges) {
        Preconditions.checkArgument(Iterables.elementsEqual(Range.normalize(ranges), ranges));
        if (this.markedDeleted) {
            return null;
        }
        ++this.activeReaders;
        return new KeyCommitStateIterator(ranges);
    }

    class KeyCommitStateIterator
    extends AbstractIterator<PaxosKeyState>
    implements PeekingKeyCommitIterator {
        private final Iterator<Range<Token>> rangeIterator;
        private final RandomAccessReader reader;
        private Range<PartitionPosition> currentRange;

        KeyCommitStateIterator(Collection<Range<Token>> ranges) {
            this.rangeIterator = ranges.iterator();
            try {
                this.reader = ChecksummedRandomAccessReader.open(UncommittedDataFile.this.file, UncommittedDataFile.this.crcFile);
            }
            catch (IOException e) {
                throw new FSReadError((Throwable)e, UncommittedDataFile.this.file);
            }
            this.validateVersion(this.reader);
            Preconditions.checkArgument(this.rangeIterator.hasNext());
            this.currentRange = this.convertRange(this.rangeIterator.next());
        }

        private Range<PartitionPosition> convertRange(Range<Token> tokenRange) {
            return new Range<PartitionPosition>(((Token)tokenRange.left).maxKeyBound(), ((Token)tokenRange.right).maxKeyBound());
        }

        private void validateVersion(RandomAccessReader reader) {
            try {
                int version = reader.readInt();
                Preconditions.checkArgument(version == 0, "unsupported file version: %s", version);
            }
            catch (IOException e) {
                throw new FSReadError((Throwable)e, UncommittedDataFile.this.file);
            }
        }

        PaxosKeyState createKeyState(DecoratedKey key, RandomAccessReader reader) throws IOException {
            return new PaxosKeyState(UncommittedDataFile.this.tableId, key, Ballot.deserialize(reader), reader.readBoolean());
        }

        void skipEntryRemainder(RandomAccessReader reader) throws IOException {
            reader.skipBytes((int)Ballot.sizeInBytes());
            reader.readBoolean();
        }

        @Override
        protected synchronized PaxosKeyState computeNext() {
            try {
                block2: while (!this.reader.isEOF()) {
                    DecoratedKey key = DatabaseDescriptor.getPartitioner().decorateKey(ByteBufferUtil.readWithShortLength(this.reader));
                    while (!this.currentRange.contains(key)) {
                        if (((PartitionPosition)this.currentRange.left).compareTo(key) >= 0) {
                            this.skipEntryRemainder(this.reader);
                            continue block2;
                        }
                        if (!this.rangeIterator.hasNext()) {
                            return (PaxosKeyState)this.endOfData();
                        }
                        this.currentRange = this.convertRange(this.rangeIterator.next());
                    }
                    return this.createKeyState(key, this.reader);
                }
                return (PaxosKeyState)this.endOfData();
            }
            catch (IOException e) {
                throw new FSReadError((Throwable)e, UncommittedDataFile.this.file);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            KeyCommitStateIterator keyCommitStateIterator = this;
            synchronized (keyCommitStateIterator) {
                this.reader.close();
            }
            UncommittedDataFile.this.onIteratorClose();
        }
    }

    static class Writer {
        final File directory;
        final String keyspace;
        final String table;
        final TableId tableId;
        long generation;
        private final File file;
        private final File crcFile;
        final SequentialWriter writer;
        DecoratedKey lastKey = null;

        private String fileName(long generation) {
            return UncommittedDataFile.fileName(this.keyspace, this.table, this.tableId, generation);
        }

        private String crcName(long generation) {
            return UncommittedDataFile.crcName(this.fileName(generation));
        }

        Writer(File directory, String keyspace, String table, TableId tableId, long generation) throws IOException {
            this.directory = directory;
            this.keyspace = keyspace;
            this.table = table;
            this.tableId = tableId;
            this.generation = generation;
            directory.createDirectoriesIfNotExists();
            this.file = new File(this.directory, this.fileName(generation) + UncommittedDataFile.TMP_SUFFIX);
            this.crcFile = new File(this.directory, this.crcName(generation) + UncommittedDataFile.TMP_SUFFIX);
            this.writer = new ChecksummedSequentialWriter(this.file, this.crcFile, null, SequentialWriterOption.DEFAULT);
            this.writer.writeInt(0);
        }

        void append(PaxosKeyState state) throws IOException {
            if (this.lastKey != null) {
                Preconditions.checkArgument(state.key.compareTo(this.lastKey) > 0);
            }
            this.lastKey = state.key;
            ByteBufferUtil.writeWithShortLength(state.key.getKey(), this.writer);
            state.ballot.serialize(this.writer);
            this.writer.writeBoolean(state.committed);
        }

        Throwable abort(Throwable accumulate) {
            return this.writer.abort(accumulate);
        }

        UncommittedDataFile finish() {
            this.writer.finish();
            File finalCrc = new File(this.directory, this.crcName(this.generation));
            File finalData = new File(this.directory, this.fileName(this.generation));
            try {
                this.crcFile.move(finalCrc);
                this.file.move(finalData);
                return new UncommittedDataFile(this.tableId, finalData, finalCrc, this.generation);
            }
            catch (Throwable e) {
                Throwable merged = e;
                for (File f : new File[]{this.crcFile, finalCrc, this.file, finalData}) {
                    try {
                        if (!f.exists()) continue;
                        Files.delete(f.toPath());
                    }
                    catch (Throwable t) {
                        merged = Throwables.merge(merged, t);
                    }
                }
                if (merged != e) {
                    throw new RuntimeException(merged);
                }
                throw e;
            }
        }
    }

    private static interface PeekingKeyCommitIterator
    extends CloseableIterator<PaxosKeyState>,
    PeekingIterator<PaxosKeyState> {
        public static final PeekingKeyCommitIterator EMPTY = new PeekingKeyCommitIterator(){

            @Override
            public PaxosKeyState peek() {
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new NoSuchElementException();
            }

            @Override
            public void close() {
            }

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public PaxosKeyState next() {
                throw new NoSuchElementException();
            }
        };
    }
}

