/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.paxos.uncommitted;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.nmoncho.shaded.com.google.common.collect.Lists;
import net.nmoncho.shaded.com.google.common.primitives.Ints;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.TimeUUIDType;
import org.apache.cassandra.db.marshal.UUIDType;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterator;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.DeserializationHelper;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.exceptions.UnknownTableException;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.TableId;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.service.paxos.Ballot;
import org.apache.cassandra.service.paxos.Commit;
import org.apache.cassandra.service.paxos.uncommitted.PaxosKeyState;
import org.apache.cassandra.utils.AbstractIterator;
import org.apache.cassandra.utils.CloseableIterator;
import org.apache.cassandra.utils.JVMStabilityInspector;

public class PaxosRows {
    private static final ColumnMetadata WRITE_PROMISE = PaxosRows.paxosColumn("in_progress_ballot", TimeUUIDType.instance);
    private static final ColumnMetadata READ_PROMISE = PaxosRows.paxosColumn("in_progress_read_ballot", TimeUUIDType.instance);
    private static final ColumnMetadata PROPOSAL = PaxosRows.paxosColumn("proposal_ballot", TimeUUIDType.instance);
    private static final ColumnMetadata PROPOSAL_UPDATE = PaxosRows.paxosColumn("proposal", BytesType.instance);
    private static final ColumnMetadata PROPOSAL_VERSION = PaxosRows.paxosColumn("proposal_version", Int32Type.instance);
    private static final ColumnMetadata COMMIT = PaxosRows.paxosColumn("most_recent_commit_at", TimeUUIDType.instance);
    private static final ColumnMetadata COMMIT_UPDATE = PaxosRows.paxosColumn("most_recent_commit", BytesType.instance);
    private static final ColumnMetadata COMMIT_VERSION = PaxosRows.paxosColumn("most_recent_commit_version", Int32Type.instance);

    private PaxosRows() {
    }

    private static ColumnMetadata paxosColumn(String name, AbstractType<?> type) {
        return ColumnMetadata.regularColumn("system", "paxos", name, type);
    }

    public static Ballot getPromise(Row row) {
        return PaxosRows.getBallot(row, READ_PROMISE, Ballot.none());
    }

    public static Ballot getWritePromise(Row row) {
        return PaxosRows.getBallot(row, WRITE_PROMISE, Ballot.none());
    }

    public static Commit.Accepted getAccepted(Row row, long purgeBefore, long overrideTtlSeconds) {
        Cell<?> ballotCell = row.getCell(PROPOSAL);
        if (ballotCell == null) {
            return null;
        }
        Ballot ballot = ballotCell.accessor().toBallot(ballotCell.value());
        if (ballot.uuidTimestamp() < purgeBefore) {
            return null;
        }
        int version = PaxosRows.getInt(row, PROPOSAL_VERSION, 10);
        PartitionUpdate update = PaxosRows.getUpdate(row, PROPOSAL_UPDATE, version);
        if (overrideTtlSeconds > 0L) {
            return new Commit.AcceptedWithTTL(ballot, update, Ints.checkedCast(TimeUnit.MICROSECONDS.toSeconds(ballotCell.timestamp()) + overrideTtlSeconds));
        }
        if (ballotCell.isExpiring()) {
            return new Commit.AcceptedWithTTL(ballot, update, ballotCell.localDeletionTime());
        }
        return new Commit.Accepted(ballot, update);
    }

    public static Commit.Committed getCommitted(TableMetadata metadata, DecoratedKey partitionKey, Row row, long purgeBefore, long overrideTtlSeconds) {
        Cell<?> ballotCell = row.getCell(COMMIT);
        if (ballotCell == null) {
            return Commit.Committed.none(partitionKey, metadata);
        }
        Ballot ballot = ballotCell.accessor().toBallot(ballotCell.value());
        if (ballot.uuidTimestamp() < purgeBefore) {
            return Commit.Committed.none(partitionKey, metadata);
        }
        int version = PaxosRows.getInt(row, COMMIT_VERSION, 10);
        PartitionUpdate update = PaxosRows.getUpdate(row, COMMIT_UPDATE, version);
        if (overrideTtlSeconds > 0L) {
            return new Commit.CommittedWithTTL(ballot, update, Ints.checkedCast(TimeUnit.MICROSECONDS.toSeconds(ballotCell.timestamp()) + overrideTtlSeconds));
        }
        if (ballotCell.isExpiring()) {
            return new Commit.CommittedWithTTL(ballot, update, ballotCell.localDeletionTime());
        }
        return new Commit.Committed(ballot, update);
    }

    public static TableId getTableId(Row row) {
        return TableId.fromUUID((UUID)UUIDType.instance.compose(row.clustering().get(0), row.clustering().accessor()));
    }

    public static UUID getTableUuid(Row row) {
        return (UUID)UUIDType.instance.compose(row.clustering().get(0), row.clustering().accessor());
    }

    private static int getInt(Row row, ColumnMetadata cmeta, int ifNull) {
        Cell<?> cell = row.getCell(cmeta);
        if (cell == null) {
            return ifNull;
        }
        return (Integer)Int32Type.instance.compose(cell.value(), cell.accessor());
    }

    private static PartitionUpdate getUpdate(Row row, ColumnMetadata cmeta, int version) {
        Cell<?> cell = row.getCell(cmeta);
        if (cell == null) {
            throw new IllegalStateException();
        }
        try {
            return PartitionUpdate.fromBytes(cell.buffer(), version);
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof UnknownTableException && version == 10) {
                return PartitionUpdate.fromBytes(cell.buffer(), 12);
            }
            throw e;
        }
    }

    private static Ballot getBallot(Row row, ColumnMetadata cmeta) {
        return PaxosRows.getBallot(row, cmeta, null);
    }

    private static Ballot getBallot(Row row, ColumnMetadata cmeta, Ballot ifNull) {
        Cell<?> cell = row.getCell(cmeta);
        if (cell == null) {
            return ifNull;
        }
        return cell.accessor().toBallot(cell.value());
    }

    private static boolean proposalIsEmpty(Row row, DecoratedKey key) {
        try {
            Cell<?> proposalVersionCell = row.getCell(PROPOSAL_VERSION);
            if (proposalVersionCell == null) {
                return true;
            }
            Integer proposalVersion = (Integer)Int32Type.instance.compose(proposalVersionCell.value(), proposalVersionCell.accessor());
            if (proposalVersion == null) {
                return true;
            }
            Cell<?> proposal = row.getCell(PROPOSAL_UPDATE);
            if (proposal == null) {
                return true;
            }
            ByteBuffer proposalValue = proposal.buffer();
            if (!proposalValue.hasRemaining()) {
                return true;
            }
            return PartitionUpdate.PartitionUpdateSerializer.isEmpty(proposalValue, DeserializationHelper.Flag.LOCAL, key);
        }
        catch (IOException e) {
            JVMStabilityInspector.inspectThrowable(e);
            throw new RuntimeException(e);
        }
    }

    private static long getTimestamp(Row row, ColumnMetadata cmeta) {
        Cell<?> cell = row.getCell(cmeta);
        if (cell == null || cell.valueSize() == 0) {
            return Long.MIN_VALUE;
        }
        return cell.timestamp();
    }

    static PaxosKeyState getCommitState(DecoratedKey key, Row row, TableId targetTableId) {
        if (row == null) {
            return null;
        }
        UUID tableUuid = PaxosRows.getTableUuid(row);
        if (targetTableId != null && !targetTableId.asUUID().equals(tableUuid)) {
            return null;
        }
        Ballot promise = Commit.latest(PaxosRows.getBallot(row, WRITE_PROMISE), PaxosRows.getBallot(row, READ_PROMISE));
        Ballot proposal = PaxosRows.getBallot(row, PROPOSAL);
        Ballot commit = PaxosRows.getBallot(row, COMMIT);
        Ballot inProgress = null;
        Ballot committed = null;
        if (Commit.isAfter(promise, proposal)) {
            if (Commit.isAfter(promise, commit)) {
                inProgress = promise;
            } else {
                committed = commit;
            }
        } else if (Commit.isAfter(proposal, commit)) {
            if (PaxosRows.proposalIsEmpty(row, key)) {
                committed = proposal;
            } else {
                inProgress = proposal;
            }
        } else {
            committed = commit;
        }
        TableId tableId = TableId.fromUUID(tableUuid);
        return inProgress != null ? new PaxosKeyState(tableId, key, inProgress, false) : new PaxosKeyState(tableId, key, committed, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static CloseableIterator<PaxosKeyState> toIterator(UnfilteredPartitionIterator partitions, TableId filterBytableId, boolean materializeLazily) {
        PaxosMemtableToKeyStateIterator iter = new PaxosMemtableToKeyStateIterator(partitions, filterBytableId);
        if (materializeLazily) {
            return iter;
        }
        try {
            CloseableIterator<PaxosKeyState> closeableIterator = CloseableIterator.wrap(Lists.newArrayList(iter).iterator());
            return closeableIterator;
        }
        finally {
            iter.close();
        }
    }

    public static Ballot getHighBallot(Row row, Ballot current) {
        long commit;
        long proposal;
        long inProgressWrite;
        long maxUnixMicros = current != null ? current.unixMicros() : Long.MIN_VALUE;
        ColumnMetadata maxCol = null;
        long inProgressRead = PaxosRows.getTimestamp(row, READ_PROMISE);
        if (inProgressRead > maxUnixMicros) {
            maxUnixMicros = inProgressRead;
            maxCol = READ_PROMISE;
        }
        if ((inProgressWrite = PaxosRows.getTimestamp(row, WRITE_PROMISE)) > maxUnixMicros) {
            maxUnixMicros = inProgressWrite;
            maxCol = WRITE_PROMISE;
        }
        if ((proposal = PaxosRows.getTimestamp(row, PROPOSAL)) > maxUnixMicros) {
            maxUnixMicros = proposal;
            maxCol = PROPOSAL;
        }
        if ((commit = PaxosRows.getTimestamp(row, COMMIT)) > maxUnixMicros) {
            maxCol = COMMIT;
        }
        return maxCol == null ? current : PaxosRows.getBallot(row, maxCol);
    }

    public static boolean hasBallotBeforeOrEqualTo(Row row, Ballot ballot) {
        return !Commit.isAfter(ballot, PaxosRows.getBallot(row, WRITE_PROMISE)) && !Commit.isAfter(ballot, PaxosRows.getBallot(row, READ_PROMISE)) && !Commit.isAfter(ballot, PaxosRows.getBallot(row, PROPOSAL)) && !Commit.isAfter(ballot, PaxosRows.getBallot(row, COMMIT));
    }

    private static class PaxosMemtableToKeyStateIterator
    extends AbstractIterator<PaxosKeyState>
    implements CloseableIterator<PaxosKeyState> {
        private final UnfilteredPartitionIterator partitions;
        private UnfilteredRowIterator partition;
        @Nullable
        private final TableId filterByTableId;

        private PaxosMemtableToKeyStateIterator(UnfilteredPartitionIterator partitions, TableId filterByTableId) {
            this.partitions = partitions;
            this.filterByTableId = filterByTableId;
        }

        @Override
        protected PaxosKeyState computeNext() {
            while (true) {
                if (this.partition != null && this.partition.hasNext()) {
                    PaxosKeyState commitState = PaxosRows.getCommitState(this.partition.partitionKey(), (Row)this.partition.next(), this.filterByTableId);
                    if (commitState == null) continue;
                    return commitState;
                }
                if (this.partition != null) {
                    this.partition.close();
                    this.partition = null;
                }
                if (!this.partitions.hasNext()) break;
                this.partition = (UnfilteredRowIterator)this.partitions.next();
            }
            this.partitions.close();
            return (PaxosKeyState)this.endOfData();
        }

        @Override
        public void close() {
            if (this.partition != null) {
                this.partition.close();
            }
            this.partitions.close();
        }
    }
}

