/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.paxos.uncommitted;

import java.util.Comparator;
import java.util.Objects;
import net.nmoncho.shaded.com.google.common.base.Preconditions;
import net.nmoncho.shaded.com.google.common.collect.Iterators;
import net.nmoncho.shaded.com.google.common.collect.Lists;
import net.nmoncho.shaded.com.google.common.collect.UnmodifiableIterator;
import net.nmoncho.shaded.com.google.common.primitives.Longs;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.schema.TableId;
import org.apache.cassandra.service.paxos.Ballot;
import org.apache.cassandra.service.paxos.uncommitted.UncommittedPaxosKey;
import org.apache.cassandra.utils.CloseableIterator;
import org.apache.cassandra.utils.MergeIterator;

public class PaxosKeyState
implements UncommittedPaxosKey {
    static final Comparator<PaxosKeyState> KEY_COMPARATOR = Comparator.comparing(o -> o.key);
    static final Comparator<PaxosKeyState> BALLOT_COMPARATOR = (o1, o2) -> Longs.compare(o1.ballot.uuidTimestamp(), o2.ballot.uuidTimestamp());
    final TableId tableId;
    final DecoratedKey key;
    final Ballot ballot;
    final boolean committed;

    public PaxosKeyState(TableId tableId, DecoratedKey key, Ballot ballot, boolean committed) {
        Preconditions.checkNotNull(tableId);
        Preconditions.checkNotNull(ballot);
        this.tableId = tableId;
        this.key = key;
        this.ballot = ballot;
        this.committed = committed;
    }

    @Override
    public DecoratedKey getKey() {
        return this.key;
    }

    @Override
    public ConsistencyLevel getConsistencyLevel() {
        switch (this.ballot.flag()) {
            default: {
                throw new IllegalStateException();
            }
            case GLOBAL: {
                return ConsistencyLevel.SERIAL;
            }
            case LOCAL: {
                return ConsistencyLevel.LOCAL_SERIAL;
            }
            case NONE: 
        }
        return null;
    }

    @Override
    public Ballot ballot() {
        return this.ballot;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaxosKeyState that = (PaxosKeyState)o;
        return this.committed == that.committed && Objects.equals(this.key, that.key) && Objects.equals(this.ballot, that.ballot);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.ballot, this.committed);
    }

    public String toString() {
        return "BallotState{tableId=" + this.tableId + ", key=" + this.key + ", ballot=" + this.ballot + ", committed=" + this.committed + '}';
    }

    static PaxosKeyState merge(PaxosKeyState left, PaxosKeyState right) {
        if (left == null) {
            return right;
        }
        if (right == null) {
            return left;
        }
        int cmp = BALLOT_COMPARATOR.compare(left, right);
        if (cmp == 0) {
            return left.committed ? left : right;
        }
        return cmp > 0 ? left : right;
    }

    public static CloseableIterator<PaxosKeyState> mergeUncommitted(CloseableIterator<PaxosKeyState> ... iterators) {
        return MergeIterator.get(Lists.newArrayList(iterators), KEY_COMPARATOR, new Reducer());
    }

    public static CloseableIterator<UncommittedPaxosKey> toUncommittedInfo(final CloseableIterator<PaxosKeyState> iter) {
        final UnmodifiableIterator<PaxosKeyState> filtered = Iterators.filter(iter, k -> !k.committed);
        return new CloseableIterator<UncommittedPaxosKey>(){

            @Override
            public void close() {
                iter.close();
            }

            @Override
            public boolean hasNext() {
                return filtered.hasNext();
            }

            @Override
            public UncommittedPaxosKey next() {
                return (UncommittedPaxosKey)filtered.next();
            }
        };
    }

    static class Reducer
    extends MergeIterator.Reducer<PaxosKeyState, PaxosKeyState> {
        private PaxosKeyState mostRecent = null;

        Reducer() {
        }

        @Override
        public void reduce(int idx, PaxosKeyState current) {
            this.mostRecent = PaxosKeyState.merge(this.mostRecent, current);
        }

        @Override
        protected PaxosKeyState getReduced() {
            return this.mostRecent;
        }

        @Override
        protected void onKeyChange() {
            super.onKeyChange();
            this.mostRecent = null;
        }
    }
}

