/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.paxos.cleanup;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import javax.annotation.Nullable;
import net.nmoncho.shaded.com.google.common.util.concurrent.FutureCallback;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.net.NoPayload;
import org.apache.cassandra.net.Verb;
import org.apache.cassandra.schema.TableId;
import org.apache.cassandra.service.paxos.cleanup.PaxosCleanup;
import org.apache.cassandra.service.paxos.cleanup.PaxosCleanupLocalCoordinator;
import org.apache.cassandra.service.paxos.cleanup.PaxosCleanupResponse;
import org.apache.cassandra.utils.UUIDSerializer;

public class PaxosCleanupRequest {
    public final UUID session;
    public final TableId tableId;
    public final Collection<Range<Token>> ranges;
    public static final IVerbHandler<PaxosCleanupRequest> verbHandler = in -> {
        final PaxosCleanupRequest request = (PaxosCleanupRequest)in.payload;
        if (!PaxosCleanup.isInRangeAndShouldProcess(request.ranges, request.tableId)) {
            String msg = String.format("Rejecting cleanup request %s from %s. Some ranges are not replicated (%s)", request.session, in.from(), request.ranges);
            Message<PaxosCleanupResponse> response = Message.out(Verb.PAXOS2_CLEANUP_RSP2, PaxosCleanupResponse.failed(request.session, msg));
            MessagingService.instance().send(response, in.respondTo());
            return;
        }
        final PaxosCleanupLocalCoordinator coordinator = PaxosCleanupLocalCoordinator.create(request);
        coordinator.addCallback(new FutureCallback<PaxosCleanupResponse>(){

            @Override
            public void onSuccess(@Nullable PaxosCleanupResponse finished) {
                Message response = Message.out(Verb.PAXOS2_CLEANUP_RSP2, coordinator.getNow());
                MessagingService.instance().send(response, in.respondTo());
            }

            @Override
            public void onFailure(Throwable throwable) {
                Message<PaxosCleanupResponse> response = Message.out(Verb.PAXOS2_CLEANUP_RSP2, PaxosCleanupResponse.failed(request.session, throwable.getMessage()));
                MessagingService.instance().send(response, in.respondTo());
            }
        });
        MessagingService.instance().respond(NoPayload.noPayload, in);
        coordinator.start();
    };
    public static final IVersionedSerializer<PaxosCleanupRequest> serializer = new IVersionedSerializer<PaxosCleanupRequest>(){

        @Override
        public void serialize(PaxosCleanupRequest completer, DataOutputPlus out, int version) throws IOException {
            UUIDSerializer.serializer.serialize(completer.session, out, version);
            completer.tableId.serialize(out);
            out.writeInt(completer.ranges.size());
            for (Range<Token> range : completer.ranges) {
                AbstractBounds.tokenSerializer.serialize(range, out, version);
            }
        }

        @Override
        public PaxosCleanupRequest deserialize(DataInputPlus in, int version) throws IOException {
            UUID session = UUIDSerializer.serializer.deserialize(in, version);
            TableId tableId = TableId.deserialize(in);
            int numRanges = in.readInt();
            ArrayList<Range<Token>> ranges = new ArrayList<Range<Token>>(numRanges);
            for (int i = 0; i < numRanges; ++i) {
                ranges.add((Range)AbstractBounds.tokenSerializer.deserialize(in, DatabaseDescriptor.getPartitioner(), version));
            }
            return new PaxosCleanupRequest(session, tableId, ranges);
        }

        @Override
        public long serializedSize(PaxosCleanupRequest completer, int version) {
            long size = UUIDSerializer.serializer.serializedSize(completer.session, version);
            size += (long)completer.tableId.serializedSize();
            size += (long)TypeSizes.sizeof(completer.ranges.size());
            for (Range<Token> range : completer.ranges) {
                size += AbstractBounds.tokenSerializer.serializedSize(range, version);
            }
            return size;
        }
    };

    static Collection<Range<Token>> rangesOrMin(Collection<Range<Token>> ranges) {
        if (ranges != null && !ranges.isEmpty()) {
            return ranges;
        }
        Token min = DatabaseDescriptor.getPartitioner().getMinimumToken();
        return Collections.singleton(new Range<Token>(min, min));
    }

    public PaxosCleanupRequest(UUID session, TableId tableId, Collection<Range<Token>> ranges) {
        this.session = session;
        this.tableId = tableId;
        this.ranges = PaxosCleanupRequest.rangesOrMin(ranges);
    }
}

