/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.paxos;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.nmoncho.shaded.com.google.common.annotations.VisibleForTesting;
import net.nmoncho.shaded.com.google.common.collect.ImmutableList;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.marshal.TupleType;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.service.paxos.Ballot;
import org.apache.cassandra.service.paxos.Commit;

public class PaxosRepairHistory {
    public static final PaxosRepairHistory EMPTY = new PaxosRepairHistory(new Token[0], new Ballot[]{Ballot.none()});
    private static final Token.TokenFactory TOKEN_FACTORY = DatabaseDescriptor.getPartitioner().getTokenFactory();
    private static final Token MIN_TOKEN = DatabaseDescriptor.getPartitioner().getMinimumToken();
    private static final TupleType TYPE = new TupleType(ImmutableList.of(BytesType.instance, BytesType.instance));
    private final Token[] tokenInclusiveUpperBound;
    private final Ballot[] ballotLowBound;
    public static final IVersionedSerializer<PaxosRepairHistory> serializer = new IVersionedSerializer<PaxosRepairHistory>(){

        @Override
        public void serialize(PaxosRepairHistory history, DataOutputPlus out, int version) throws IOException {
            out.writeUnsignedVInt(history.size());
            for (int i = 0; i < history.size(); ++i) {
                Token.serializer.serialize(history.tokenInclusiveUpperBound[i], out, version);
                history.ballotLowBound[i].serialize(out);
            }
            history.ballotLowBound[history.size()].serialize(out);
        }

        @Override
        public PaxosRepairHistory deserialize(DataInputPlus in, int version) throws IOException {
            int size = (int)in.readUnsignedVInt();
            Token[] tokenInclusiveUpperBounds = new Token[size];
            Ballot[] ballotLowBounds = new Ballot[size + 1];
            for (int i = 0; i < size; ++i) {
                tokenInclusiveUpperBounds[i] = Token.serializer.deserialize(in, DatabaseDescriptor.getPartitioner(), version);
                ballotLowBounds[i] = Ballot.deserialize(in);
            }
            ballotLowBounds[size] = Ballot.deserialize(in);
            return new PaxosRepairHistory(tokenInclusiveUpperBounds, ballotLowBounds);
        }

        @Override
        public long serializedSize(PaxosRepairHistory history, int version) {
            long size = TypeSizes.sizeofUnsignedVInt(history.size());
            for (int i = 0; i < history.size(); ++i) {
                size += Token.serializer.serializedSize(history.tokenInclusiveUpperBound[i], version);
                size += Ballot.sizeInBytes();
            }
            return size += Ballot.sizeInBytes();
        }
    };

    PaxosRepairHistory(Token[] tokenInclusiveUpperBound, Ballot[] ballotLowBound) {
        assert (ballotLowBound.length == tokenInclusiveUpperBound.length + 1);
        this.tokenInclusiveUpperBound = tokenInclusiveUpperBound;
        this.ballotLowBound = ballotLowBound;
    }

    public Ballot maxLowBound() {
        Ballot maxBallot = Ballot.none();
        for (Ballot lowBound : this.ballotLowBound) {
            maxBallot = Commit.latest(maxBallot, lowBound);
        }
        return maxBallot;
    }

    public String toString() {
        return "PaxosRepairHistory{" + IntStream.range(0, this.ballotLowBound.length).filter(i -> !Ballot.none().equals(this.ballotLowBound[i])).mapToObj(i -> this.range(i) + "=" + this.ballotLowBound[i]).collect(Collectors.joining(", ")) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaxosRepairHistory that = (PaxosRepairHistory)o;
        return Arrays.equals(this.ballotLowBound, that.ballotLowBound) && Arrays.equals(this.tokenInclusiveUpperBound, that.tokenInclusiveUpperBound);
    }

    public int hashCode() {
        return Arrays.hashCode(this.ballotLowBound);
    }

    public Ballot ballotForToken(Token token) {
        int idx = Arrays.binarySearch(this.tokenInclusiveUpperBound, token);
        if (idx < 0) {
            idx = -1 - idx;
        }
        return this.ballotLowBound[idx];
    }

    private Ballot ballotForIndex(int idx) {
        if (idx < 0 || idx > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        return this.ballotLowBound[idx];
    }

    private int indexForToken(Token token) {
        int idx = Arrays.binarySearch(this.tokenInclusiveUpperBound, token);
        if (idx < 0) {
            idx = -1 - idx;
        }
        return idx;
    }

    private boolean contains(int idx, Token token) {
        if (idx < 0 || idx > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        return !(idx != 0 && this.tokenInclusiveUpperBound[idx - 1].compareTo(token) >= 0 || idx != this.size() && this.tokenInclusiveUpperBound[idx].compareTo(token) < 0);
    }

    public int size() {
        return this.tokenInclusiveUpperBound.length;
    }

    private RangeIterator rangeIterator() {
        return new RangeIterator();
    }

    private Range<Token> range(int i) {
        return new Range<Token>(this.tokenExclusiveLowerBound(i), this.tokenInclusiveUpperBound(i));
    }

    public Searcher searcher() {
        return new Searcher();
    }

    private Token tokenExclusiveLowerBound(int i) {
        return i == 0 ? MIN_TOKEN : this.tokenInclusiveUpperBound[i - 1];
    }

    private Token tokenInclusiveUpperBound(int i) {
        return i == this.tokenInclusiveUpperBound.length ? MIN_TOKEN : this.tokenInclusiveUpperBound[i];
    }

    public List<ByteBuffer> toTupleBufferList() {
        ArrayList<ByteBuffer> tuples = new ArrayList<ByteBuffer>(this.size() + 1);
        for (int i = 0; i < 1 + this.size(); ++i) {
            tuples.add(TupleType.buildValue(new ByteBuffer[]{TOKEN_FACTORY.toByteArray(this.tokenInclusiveUpperBound(i)), this.ballotLowBound[i].toBytes()}));
        }
        return tuples;
    }

    public static PaxosRepairHistory fromTupleBufferList(List<ByteBuffer> tuples) {
        Token[] tokenInclusiveUpperBounds = new Token[tuples.size() - 1];
        Ballot[] ballotLowBounds = new Ballot[tuples.size()];
        for (int i = 0; i < tuples.size(); ++i) {
            ByteBuffer[] split = TYPE.split(tuples.get(i));
            if (i < tokenInclusiveUpperBounds.length) {
                tokenInclusiveUpperBounds[i] = TOKEN_FACTORY.fromByteArray(split[0]);
            }
            ballotLowBounds[i] = Ballot.deserialize(split[1]);
        }
        return new PaxosRepairHistory(tokenInclusiveUpperBounds, ballotLowBounds);
    }

    public static PaxosRepairHistory merge(PaxosRepairHistory historyLeft, PaxosRepairHistory historyRight) {
        if (historyLeft == null) {
            return historyRight;
        }
        if (historyRight == null) {
            return historyLeft;
        }
        Builder builder = new Builder(historyLeft.size() + historyRight.size());
        RangeIterator left = historyLeft.rangeIterator();
        RangeIterator right = historyRight.rangeIterator();
        while (left.hasUpperBound() && right.hasUpperBound()) {
            int cmp = left.tokenInclusiveUpperBound().compareTo(right.tokenInclusiveUpperBound());
            Ballot ballot = Commit.latest(left.ballotLowBound(), right.ballotLowBound());
            if (cmp == 0) {
                builder.append(left.tokenInclusiveUpperBound(), ballot);
                left.next();
                right.next();
                continue;
            }
            RangeIterator firstIter = cmp < 0 ? left : right;
            builder.append(firstIter.tokenInclusiveUpperBound(), ballot);
            firstIter.next();
        }
        while (left.hasUpperBound()) {
            builder.append(left.tokenInclusiveUpperBound(), Commit.latest(left.ballotLowBound(), right.ballotLowBound()));
            left.next();
        }
        while (right.hasUpperBound()) {
            builder.append(right.tokenInclusiveUpperBound(), Commit.latest(left.ballotLowBound(), right.ballotLowBound()));
            right.next();
        }
        builder.appendLast(Commit.latest(left.ballotLowBound(), right.ballotLowBound()));
        return builder.build();
    }

    @VisibleForTesting
    public static PaxosRepairHistory add(PaxosRepairHistory existing, Collection<Range<Token>> ranges, Ballot ballot) {
        ranges = Range.normalize(ranges);
        Builder builder = new Builder(ranges.size() * 2);
        for (Range range : ranges) {
            builder.appendMaybeMin((Token)range.left, Ballot.none());
            builder.appendMaybeMax((Token)range.right, ballot);
        }
        return PaxosRepairHistory.merge(existing, builder.build());
    }

    @VisibleForTesting
    static PaxosRepairHistory trim(PaxosRepairHistory existing, Collection<Range<Token>> ranges) {
        Builder builder = new Builder(existing.size());
        ranges = Range.normalize(ranges);
        for (Range<Token> range : ranges) {
            RangeIterator intersects = existing.intersects(range);
            while (intersects.hasNext()) {
                if (Ballot.none().equals(intersects.ballotLowBound())) {
                    intersects.next();
                    continue;
                }
                Token exclusiveLowerBound = PaxosRepairHistory.maxExclusiveLowerBound((Token)range.left, intersects.tokenExclusiveLowerBound());
                Token inclusiveUpperBound = PaxosRepairHistory.minInclusiveUpperBound((Token)range.right, intersects.tokenInclusiveUpperBound());
                assert (exclusiveLowerBound.compareTo(inclusiveUpperBound) < 0 || inclusiveUpperBound.isMinimum());
                builder.appendMaybeMin(exclusiveLowerBound, Ballot.none());
                builder.appendMaybeMax(inclusiveUpperBound, intersects.ballotLowBound());
                intersects.next();
            }
        }
        return builder.build();
    }

    RangeIterator intersects(Range<Token> unwrapped) {
        int to;
        int from = Arrays.binarySearch(this.tokenInclusiveUpperBound, unwrapped.left);
        from = from < 0 ? -1 - from : ++from;
        int n = to = ((Token)unwrapped.right).isMinimum() ? this.ballotLowBound.length - 1 : Arrays.binarySearch(this.tokenInclusiveUpperBound, unwrapped.right);
        if (to < 0) {
            to = -1 - to;
        }
        return new RangeIterator(from, Math.min(1 + to, this.ballotLowBound.length));
    }

    private static Token maxExclusiveLowerBound(Token a, Token b) {
        return a.compareTo(b) < 0 ? b : a;
    }

    private static Token minInclusiveUpperBound(Token a, Token b) {
        if (!a.isMinimum() && !b.isMinimum()) {
            return a.compareTo(b) <= 0 ? a : b;
        }
        if (!a.isMinimum()) {
            return a;
        }
        if (!b.isMinimum()) {
            return b;
        }
        return a;
    }

    static class Builder {
        final List<Token> tokenInclusiveUpperBounds;
        final List<Ballot> ballotLowBounds;

        Builder(int capacity) {
            this.tokenInclusiveUpperBounds = new ArrayList<Token>(capacity);
            this.ballotLowBounds = new ArrayList<Ballot>(capacity + 1);
        }

        void appendMaybeMin(Token inclusiveLowBound, Ballot ballotLowBound) {
            if (inclusiveLowBound.isMinimum()) {
                assert (ballotLowBound.equals(Ballot.none()) && this.ballotLowBounds.isEmpty());
            } else {
                this.append(inclusiveLowBound, ballotLowBound);
            }
        }

        void appendMaybeMax(Token inclusiveLowBound, Ballot ballotLowBound) {
            if (inclusiveLowBound.isMinimum()) {
                this.appendLast(ballotLowBound);
            } else {
                this.append(inclusiveLowBound, ballotLowBound);
            }
        }

        void append(Token inclusiveLowBound, Ballot ballotLowBound) {
            boolean sameAsTailBallot;
            int tailIdx = this.tokenInclusiveUpperBounds.size() - 1;
            assert (this.tokenInclusiveUpperBounds.size() == this.ballotLowBounds.size());
            assert (tailIdx < 0 || inclusiveLowBound.compareTo(this.tokenInclusiveUpperBounds.get(tailIdx)) >= 0);
            boolean sameAsTailToken = tailIdx >= 0 && inclusiveLowBound.equals(this.tokenInclusiveUpperBounds.get(tailIdx));
            boolean bl = sameAsTailBallot = tailIdx >= 0 && ballotLowBound.equals(this.ballotLowBounds.get(tailIdx));
            if (sameAsTailToken || sameAsTailBallot) {
                if (sameAsTailBallot) {
                    this.tokenInclusiveUpperBounds.set(tailIdx, inclusiveLowBound);
                } else if (Commit.isAfter(ballotLowBound, this.ballotLowBounds.get(tailIdx))) {
                    this.ballotLowBounds.set(tailIdx, ballotLowBound);
                }
            } else {
                this.tokenInclusiveUpperBounds.add(inclusiveLowBound);
                this.ballotLowBounds.add(ballotLowBound);
            }
        }

        void appendLast(Ballot ballotLowBound) {
            assert (this.ballotLowBounds.size() == this.tokenInclusiveUpperBounds.size());
            int tailIdx = this.tokenInclusiveUpperBounds.size() - 1;
            if (!this.ballotLowBounds.isEmpty() && ballotLowBound.equals(this.ballotLowBounds.get(tailIdx))) {
                this.tokenInclusiveUpperBounds.remove(tailIdx);
            } else {
                this.ballotLowBounds.add(ballotLowBound);
            }
        }

        PaxosRepairHistory build() {
            if (this.tokenInclusiveUpperBounds.size() == this.ballotLowBounds.size()) {
                this.ballotLowBounds.add(Ballot.none());
            }
            return new PaxosRepairHistory(this.tokenInclusiveUpperBounds.toArray(new Token[0]), this.ballotLowBounds.toArray(new Ballot[0]));
        }
    }

    class RangeIterator {
        final int end;
        int i;

        RangeIterator() {
            this.end = PaxosRepairHistory.this.ballotLowBound.length;
        }

        RangeIterator(int from, int to) {
            this.i = from;
            this.end = to;
        }

        boolean hasNext() {
            return this.i < this.end;
        }

        boolean hasUpperBound() {
            return this.i < PaxosRepairHistory.this.tokenInclusiveUpperBound.length;
        }

        void next() {
            ++this.i;
        }

        Token tokenExclusiveLowerBound() {
            return PaxosRepairHistory.this.tokenExclusiveLowerBound(this.i);
        }

        Token tokenInclusiveUpperBound() {
            return PaxosRepairHistory.this.tokenInclusiveUpperBound(this.i);
        }

        Ballot ballotLowBound() {
            return PaxosRepairHistory.this.ballotLowBound[this.i];
        }
    }

    public class Searcher {
        int idx = -1;

        public Ballot ballotForToken(Token token) {
            if (this.idx < 0 || !PaxosRepairHistory.this.contains(this.idx, token)) {
                this.idx = PaxosRepairHistory.this.indexForToken(token);
            }
            return PaxosRepairHistory.this.ballotForIndex(this.idx);
        }
    }
}

