/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.paxos;

import java.io.IOException;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.nmoncho.shaded.com.google.common.base.Objects;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.db.rows.DeserializationHelper;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.service.paxos.Ballot;
import org.apache.cassandra.utils.FBUtilities;

public class Commit {
    public static final CommitSerializer<Commit> serializer = new CommitSerializer<Commit>(Commit::new);
    public final Ballot ballot;
    public final PartitionUpdate update;

    public Commit(Ballot ballot, PartitionUpdate update) {
        assert (ballot != null);
        assert (update != null);
        this.ballot = ballot;
        this.update = update;
    }

    public static Commit newPrepare(DecoratedKey partitionKey, TableMetadata metadata, Ballot ballot) {
        return new Commit(ballot, PartitionUpdate.emptyUpdate(metadata, partitionKey));
    }

    public static Commit emptyCommit(DecoratedKey partitionKey, TableMetadata metadata) {
        return new Commit(Ballot.none(), PartitionUpdate.emptyUpdate(metadata, partitionKey));
    }

    @Deprecated
    public static Commit newProposal(Ballot ballot, PartitionUpdate update) {
        update = Commit.withTimestamp(update, ballot.unixMicros());
        return new Commit(ballot, update);
    }

    public boolean isAfter(Commit other) {
        return other == null || this.ballot.uuidTimestamp() > other.ballot.uuidTimestamp();
    }

    public boolean isSameOrAfter(@Nullable Ballot otherBallot) {
        return otherBallot == null || otherBallot.equals(this.ballot) || this.ballot.uuidTimestamp() > otherBallot.uuidTimestamp();
    }

    public boolean isAfter(@Nullable Ballot otherBallot) {
        return otherBallot == null || this.ballot.uuidTimestamp() > otherBallot.uuidTimestamp();
    }

    public boolean isBefore(@Nullable Ballot otherBallot) {
        return otherBallot != null && this.ballot.uuidTimestamp() < otherBallot.uuidTimestamp();
    }

    public boolean hasBallot(Ballot ballot) {
        return this.ballot.equals(ballot);
    }

    public boolean hasSameBallot(Commit other) {
        return this.ballot.equals(other.ballot);
    }

    public Mutation makeMutation() {
        return new Mutation(this.update);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Commit commit = (Commit)o;
        return this.ballot.equals(commit.ballot) && this.update.equals(commit.update);
    }

    public int hashCode() {
        return Objects.hashCode(this.ballot, this.update);
    }

    public String toString() {
        return this.toString("Commit");
    }

    public String toString(String kind) {
        return String.format("%s(%d:%s, %d:%s)", kind, this.ballot.uuidTimestamp(), this.ballot, this.update.stats().minTimestamp, this.update.toString(false));
    }

    public boolean isReproposalOf(Commit older) {
        return this.isReproposal(older, older.ballot.uuidTimestamp(), this, this.ballot.uuidTimestamp());
    }

    private boolean isReproposal(Commit older, long ballotOfOlder, Commit newer, long ballotOfNewer) {
        long originalBallotOfNewer = newer.update.stats().minTimestamp;
        if (ballotOfNewer == originalBallotOfNewer) {
            return false;
        }
        if (originalBallotOfNewer == ballotOfOlder) {
            return true;
        }
        return originalBallotOfNewer == older.update.stats().minTimestamp;
    }

    public CompareResult compareWith(Commit that) {
        long thatBallot;
        long thisBallot = this.ballot.uuidTimestamp();
        if (thisBallot == (thatBallot = that.ballot.uuidTimestamp())) {
            return CompareResult.SAME;
        }
        if (thisBallot < thatBallot) {
            return this.isReproposal(this, thisBallot, that, thatBallot) ? CompareResult.WAS_REPROPOSED_BY : CompareResult.BEFORE;
        }
        return this.isReproposal(that, thatBallot, this, thisBallot) ? CompareResult.IS_REPROPOSAL : CompareResult.AFTER;
    }

    private static int compare(@Nullable Commit a, @Nullable Commit b) {
        if (a == null) {
            return 1;
        }
        if (b == null) {
            return -1;
        }
        return Long.compare(a.ballot.uuidTimestamp(), b.ballot.uuidTimestamp());
    }

    public static boolean isAfter(@Nullable Commit testIsAfter, @Nullable Commit testIsBefore) {
        return testIsAfter != null && testIsAfter.isAfter(testIsBefore);
    }

    public static boolean isAfter(@Nullable Ballot testIsAfter, @Nullable Commit testIsBefore) {
        return testIsAfter != null && (testIsBefore == null || testIsAfter.uuidTimestamp() > testIsBefore.ballot.uuidTimestamp());
    }

    public static boolean isAfter(@Nullable Commit testIsAfter, @Nullable Ballot testIsBefore) {
        return testIsAfter != null && (testIsBefore == null || testIsAfter.ballot.uuidTimestamp() > testIsBefore.uuidTimestamp());
    }

    public static boolean isAfter(@Nullable Ballot testIsAfter, @Nullable Ballot testIsBefore) {
        return testIsAfter != null && (testIsBefore == null || testIsAfter.uuidTimestamp() > testIsBefore.uuidTimestamp());
    }

    public static <C extends Commit> C latest(@Nullable C a, @Nullable C b) {
        return a == null | b == null ? (a == null ? b : a) : (a.ballot.uuidTimestamp() >= b.ballot.uuidTimestamp() ? a : b);
    }

    public static Ballot latest(@Nullable Commit a, @Nullable Ballot b) {
        return a == null | b == null ? (a == null ? b : a.ballot) : (a.ballot.uuidTimestamp() >= b.uuidTimestamp() ? a.ballot : b);
    }

    public static Ballot latest(@Nullable Ballot a, @Nullable Ballot b) {
        return a == null | b == null ? (a == null ? b : a) : (a.uuidTimestamp() >= b.uuidTimestamp() ? a : b);
    }

    public static boolean timestampsClash(@Nullable Commit a, @Nullable Ballot b) {
        return a != null && b != null && !a.ballot.equals(b) && a.ballot.uuidTimestamp() == b.uuidTimestamp();
    }

    public static boolean timestampsClash(@Nullable Ballot a, @Nullable Ballot b) {
        return a != null && b != null && !a.equals(b) && a.uuidTimestamp() == b.uuidTimestamp();
    }

    private static PartitionUpdate withTimestamp(PartitionUpdate update, long timestamp) {
        return new PartitionUpdate.Builder(update, 0).updateAllTimestamp(timestamp).build();
    }

    public static class CommitSerializer<T extends Commit>
    implements IVersionedSerializer<T> {
        final BiFunction<Ballot, PartitionUpdate, T> constructor;

        public CommitSerializer(BiFunction<Ballot, PartitionUpdate, T> constructor) {
            this.constructor = constructor;
        }

        @Override
        public void serialize(T commit, DataOutputPlus out, int version) throws IOException {
            ((Commit)commit).ballot.serialize(out);
            PartitionUpdate.serializer.serialize(((Commit)commit).update, out, version);
        }

        @Override
        public T deserialize(DataInputPlus in, int version) throws IOException {
            Ballot ballot = Ballot.deserialize(in);
            PartitionUpdate update = PartitionUpdate.serializer.deserialize(in, version, DeserializationHelper.Flag.LOCAL);
            return (T)((Commit)this.constructor.apply(ballot, update));
        }

        @Override
        public long serializedSize(T commit, int version) {
            return Ballot.sizeInBytes() + PartitionUpdate.serializer.serializedSize(((Commit)commit).update, version);
        }
    }

    public static class CommittedWithTTL
    extends Committed {
        public final int localDeletionTime;

        public static CommittedWithTTL withDefaultTTL(Commit copy) {
            return new CommittedWithTTL(copy, FBUtilities.nowInSeconds() + SystemKeyspace.legacyPaxosTtlSec(copy.update.metadata()));
        }

        public CommittedWithTTL(Ballot ballot, PartitionUpdate update, int localDeletionTime) {
            super(ballot, update);
            this.localDeletionTime = localDeletionTime;
        }

        public CommittedWithTTL(Commit copy, int localDeletionTime) {
            super(copy);
            this.localDeletionTime = localDeletionTime;
        }

        @Override
        boolean isExpired(int nowInSec) {
            return nowInSec >= this.localDeletionTime;
        }

        Committed lastDeleted(Committed b) {
            return b instanceof CommittedWithTTL && this.localDeletionTime >= ((CommittedWithTTL)b).localDeletionTime ? this : b;
        }
    }

    public static class Committed
    extends Agreed {
        public static final CommitSerializer<Committed> serializer = new CommitSerializer<Committed>(Committed::new);

        public static Committed none(DecoratedKey partitionKey, TableMetadata metadata) {
            return new Committed(Ballot.none(), PartitionUpdate.emptyUpdate(metadata, partitionKey));
        }

        public Committed(Ballot ballot, PartitionUpdate update) {
            super(ballot, update);
        }

        public Committed(Commit copy) {
            super(copy);
        }

        @Override
        public String toString() {
            return this.toString("Committed");
        }

        public static Committed latestCommitted(Committed a, Committed b) {
            int c = Commit.compare((Commit)a, (Commit)b);
            if (c != 0) {
                return c > 0 ? a : b;
            }
            return a instanceof CommittedWithTTL ? ((CommittedWithTTL)a).lastDeleted(b) : a;
        }

        public boolean isNone() {
            return this.ballot.equals(Ballot.none()) && this.update.isEmpty();
        }
    }

    public static class Agreed
    extends Accepted {
        public static final CommitSerializer<Agreed> serializer = new CommitSerializer<Agreed>(Agreed::new);

        public Agreed(Ballot ballot, PartitionUpdate update) {
            super(ballot, update);
        }

        public Agreed(Commit copy) {
            super(copy);
        }
    }

    public static class AcceptedWithTTL
    extends Accepted {
        public final int localDeletionTime;

        public static AcceptedWithTTL withDefaultTTL(Commit copy) {
            return new AcceptedWithTTL(copy, FBUtilities.nowInSeconds() + SystemKeyspace.legacyPaxosTtlSec(copy.update.metadata()));
        }

        public AcceptedWithTTL(Commit copy, int localDeletionTime) {
            super(copy);
            this.localDeletionTime = localDeletionTime;
        }

        public AcceptedWithTTL(Ballot ballot, PartitionUpdate update, int localDeletionTime) {
            super(ballot, update);
            this.localDeletionTime = localDeletionTime;
        }

        @Override
        boolean isExpired(int nowInSec) {
            return nowInSec >= this.localDeletionTime;
        }

        Accepted lastDeleted(Accepted b) {
            return b instanceof AcceptedWithTTL && this.localDeletionTime >= ((AcceptedWithTTL)b).localDeletionTime ? this : b;
        }
    }

    public static class Accepted
    extends Proposal {
        public static final CommitSerializer<Accepted> serializer = new CommitSerializer<Accepted>(Accepted::new);

        public static Accepted none(DecoratedKey partitionKey, TableMetadata metadata) {
            return new Accepted(Ballot.none(), PartitionUpdate.emptyUpdate(metadata, partitionKey));
        }

        public Accepted(Ballot ballot, PartitionUpdate update) {
            super(ballot, update);
        }

        public Accepted(Commit commit) {
            super(commit.ballot, commit.update);
        }

        Committed committed() {
            return new Committed(this.ballot, this.update);
        }

        boolean isExpired(int nowInSec) {
            return false;
        }

        @Override
        public String toString() {
            return this.toString("Accepted");
        }

        public static Accepted latestAccepted(Accepted a, Accepted b) {
            int c = Commit.compare((Commit)a, (Commit)b);
            if (c != 0) {
                return c > 0 ? a : b;
            }
            return a instanceof AcceptedWithTTL ? ((AcceptedWithTTL)a).lastDeleted(b) : a;
        }
    }

    public static class Proposal
    extends Commit {
        public static final CommitSerializer<Proposal> serializer = new CommitSerializer<Proposal>(Proposal::new);

        public Proposal(Ballot ballot, PartitionUpdate update) {
            super(ballot, update);
        }

        @Override
        public String toString() {
            return this.toString("Proposal");
        }

        public static Proposal of(Ballot ballot, PartitionUpdate update) {
            update = Commit.withTimestamp(update, ballot.unixMicros());
            return new Proposal(ballot, update);
        }

        public static Proposal empty(Ballot ballot, DecoratedKey partitionKey, TableMetadata metadata) {
            return new Proposal(ballot, PartitionUpdate.emptyUpdate(metadata, partitionKey));
        }

        public Accepted accepted() {
            return new Accepted(this.ballot, this.update);
        }

        public Agreed agreed() {
            return new Agreed(this.ballot, this.update);
        }
    }

    static enum CompareResult {
        SAME,
        BEFORE,
        AFTER,
        IS_REPROPOSAL,
        WAS_REPROPOSED_BY;

    }
}

