/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.disk.usage;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import net.nmoncho.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.cassandra.gms.ApplicationState;
import org.apache.cassandra.gms.EndpointState;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.gms.IEndpointStateChangeSubscriber;
import org.apache.cassandra.gms.VersionedValue;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.service.disk.usage.DiskUsageMonitor;
import org.apache.cassandra.service.disk.usage.DiskUsageState;
import org.apache.cassandra.utils.NoSpamLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiskUsageBroadcaster
implements IEndpointStateChangeSubscriber {
    private static final Logger logger = LoggerFactory.getLogger(DiskUsageBroadcaster.class);
    private static final NoSpamLogger noSpamLogger = NoSpamLogger.getLogger(logger, 10L, TimeUnit.MINUTES);
    public static final DiskUsageBroadcaster instance = new DiskUsageBroadcaster(DiskUsageMonitor.instance);
    private final DiskUsageMonitor monitor;
    private final ConcurrentMap<InetAddressAndPort, DiskUsageState> usageInfo = new ConcurrentHashMap<InetAddressAndPort, DiskUsageState>();
    private volatile boolean hasStuffedOrFullNode = false;

    @VisibleForTesting
    public DiskUsageBroadcaster(DiskUsageMonitor monitor) {
        this.monitor = monitor;
        Gossiper.instance.register(this);
    }

    public boolean hasStuffedOrFullNode() {
        return this.hasStuffedOrFullNode;
    }

    public boolean isFull(InetAddressAndPort endpoint) {
        return this.state(endpoint).isFull();
    }

    public boolean isStuffed(InetAddressAndPort endpoint) {
        return this.state(endpoint).isStuffed();
    }

    @VisibleForTesting
    public DiskUsageState state(InetAddressAndPort endpoint) {
        return this.usageInfo.getOrDefault(endpoint, DiskUsageState.NOT_AVAILABLE);
    }

    public void startBroadcasting() {
        this.monitor.start(newState -> {
            if (logger.isTraceEnabled()) {
                logger.trace("Disseminating disk usage info: {}", (Object)newState);
            }
            Gossiper.instance.addLocalApplicationState(ApplicationState.DISK_USAGE, StorageService.instance.valueFactory.diskUsage(newState.name()));
        });
    }

    @Override
    public void onChange(InetAddressAndPort endpoint, ApplicationState state, VersionedValue value) {
        if (state != ApplicationState.DISK_USAGE) {
            return;
        }
        DiskUsageState usageState = DiskUsageState.NOT_AVAILABLE;
        try {
            usageState = DiskUsageState.valueOf(value.value);
        }
        catch (IllegalArgumentException e) {
            noSpamLogger.warn(String.format("Found unknown DiskUsageState: %s. Using default state %s instead.", new Object[]{value.value, usageState}), new Object[0]);
        }
        this.usageInfo.put(endpoint, usageState);
        this.hasStuffedOrFullNode = usageState.isStuffedOrFull() || this.computeHasStuffedOrFullNode();
    }

    private boolean computeHasStuffedOrFullNode() {
        for (DiskUsageState replicaState : this.usageInfo.values()) {
            if (!replicaState.isStuffedOrFull()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void onJoin(InetAddressAndPort endpoint, EndpointState epState) {
        this.updateDiskUsage(endpoint, epState);
    }

    @Override
    public void beforeChange(InetAddressAndPort endpoint, EndpointState currentState, ApplicationState newStateKey, VersionedValue newValue) {
    }

    @Override
    public void onAlive(InetAddressAndPort endpoint, EndpointState state) {
        this.updateDiskUsage(endpoint, state);
    }

    @Override
    public void onDead(InetAddressAndPort endpoint, EndpointState state) {
    }

    @Override
    public void onRestart(InetAddressAndPort endpoint, EndpointState state) {
        this.updateDiskUsage(endpoint, state);
    }

    @Override
    public void onRemove(InetAddressAndPort endpoint) {
        this.usageInfo.remove(endpoint);
        this.hasStuffedOrFullNode = this.usageInfo.values().stream().anyMatch(DiskUsageState::isStuffedOrFull);
    }

    private void updateDiskUsage(InetAddressAndPort endpoint, EndpointState state) {
        VersionedValue localValue = state.getApplicationState(ApplicationState.DISK_USAGE);
        if (localValue != null) {
            this.onChange(endpoint, ApplicationState.DISK_USAGE, localValue);
        }
    }
}

