/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.security;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;
import net.nmoncho.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.cassandra.io.util.File;
import org.apache.cassandra.security.AbstractSslContextFactory;
import org.apache.cassandra.utils.Clock;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FileBasedSslContextFactory
extends AbstractSslContextFactory {
    private static final Logger logger = LoggerFactory.getLogger(FileBasedSslContextFactory.class);
    @VisibleForTesting
    protected volatile boolean checkedExpiry = false;
    protected volatile List<HotReloadableFile> hotReloadableFiles = new ArrayList<HotReloadableFile>();
    protected String keystore;
    protected String keystore_password;
    protected String truststore;
    protected String truststore_password;

    public FileBasedSslContextFactory() {
        this.keystore = "conf/.keystore";
        this.keystore_password = "cassandra";
        this.truststore = "conf/.truststore";
        this.truststore_password = "cassandra";
    }

    public FileBasedSslContextFactory(Map<String, Object> parameters) {
        super(parameters);
        this.keystore = this.getString("keystore");
        this.keystore_password = this.getString("keystore_password");
        this.truststore = this.getString("truststore");
        this.truststore_password = this.getString("truststore_password");
    }

    @Override
    public boolean shouldReload() {
        return this.hotReloadableFiles.stream().anyMatch(HotReloadableFile::shouldReload);
    }

    @Override
    public boolean hasKeystore() {
        return this.keystore != null && new File(this.keystore).exists();
    }

    private boolean hasTruststore() {
        return this.truststore != null && new File(this.truststore).exists();
    }

    @Override
    public synchronized void initHotReloading() {
        boolean hasKeystore = this.hasKeystore();
        boolean hasTruststore = this.hasTruststore();
        if (hasKeystore || hasTruststore) {
            ArrayList<HotReloadableFile> fileList = new ArrayList<HotReloadableFile>();
            if (hasKeystore) {
                fileList.add(new HotReloadableFile(this.keystore));
            }
            if (hasTruststore) {
                fileList.add(new HotReloadableFile(this.truststore));
            }
            this.hotReloadableFiles = fileList;
        }
    }

    protected void validatePassword(String password) {
        if (password == null) {
            throw new IllegalArgumentException("'keystore_password' must be specified");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected KeyManagerFactory buildKeyManagerFactory() throws SSLException {
        this.validatePassword(this.keystore_password);
        try (InputStream ksf = Files.newInputStream(File.getPath(this.keystore, new String[0]), new OpenOption[0]);){
            String algorithm = this.algorithm == null ? KeyManagerFactory.getDefaultAlgorithm() : this.algorithm;
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(algorithm);
            KeyStore ks = KeyStore.getInstance(this.store_type);
            char[] password = this.keystore_password.toCharArray();
            ks.load(ksf, password);
            if (!this.checkedExpiry) {
                this.checkExpiredCerts(ks);
                this.checkedExpiry = true;
            }
            kmf.init(ks, password);
            KeyManagerFactory keyManagerFactory = kmf;
            return keyManagerFactory;
        }
        catch (Exception e) {
            throw new SSLException("failed to build key manager store for secure connections", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected TrustManagerFactory buildTrustManagerFactory() throws SSLException {
        try (InputStream tsf = Files.newInputStream(File.getPath(this.truststore, new String[0]), new OpenOption[0]);){
            String algorithm = this.algorithm == null ? TrustManagerFactory.getDefaultAlgorithm() : this.algorithm;
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(algorithm);
            KeyStore ts = KeyStore.getInstance(this.store_type);
            char[] truststorePassword = StringUtils.isEmpty((CharSequence)this.truststore_password) ? null : this.truststore_password.toCharArray();
            ts.load(tsf, truststorePassword);
            tmf.init(ts);
            TrustManagerFactory trustManagerFactory = tmf;
            return trustManagerFactory;
        }
        catch (Exception e) {
            throw new SSLException("failed to build trust manager store for secure connections", e);
        }
    }

    protected boolean checkExpiredCerts(KeyStore ks) throws KeyStoreException {
        boolean hasExpiredCerts = false;
        Date now = new Date(Clock.Global.currentTimeMillis());
        Enumeration<String> aliases = ks.aliases();
        while (aliases.hasMoreElements()) {
            Date expires;
            String alias = aliases.nextElement();
            if (!ks.getCertificate(alias).getType().equals("X.509") || !(expires = ((X509Certificate)ks.getCertificate(alias)).getNotAfter()).before(now)) continue;
            hasExpiredCerts = true;
            logger.warn("Certificate for {} expired on {}", (Object)alias, (Object)expires);
        }
        return hasExpiredCerts;
    }

    protected static class HotReloadableFile {
        private final File file;
        private volatile long lastModTime;

        HotReloadableFile(String path) {
            this.file = new File(path);
            this.lastModTime = this.file.lastModified();
        }

        boolean shouldReload() {
            long curModTime = this.file.lastModified();
            boolean result = curModTime != this.lastModTime;
            this.lastModTime = curModTime;
            return result;
        }

        public String toString() {
            return "HotReloadableFile{file=" + this.file + ", lastModTime=" + this.lastModTime + '}';
        }
    }
}

