/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.security;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import net.nmoncho.shaded.com.google.common.collect.ImmutableList;
import net.nmoncho.shaded.io.netty.handler.ssl.CipherSuiteFilter;
import net.nmoncho.shaded.io.netty.handler.ssl.ClientAuth;
import net.nmoncho.shaded.io.netty.handler.ssl.OpenSsl;
import net.nmoncho.shaded.io.netty.handler.ssl.SslContext;
import net.nmoncho.shaded.io.netty.handler.ssl.SslContextBuilder;
import net.nmoncho.shaded.io.netty.handler.ssl.SslProvider;
import org.apache.cassandra.security.ISslContextFactory;
import org.apache.cassandra.security.SSLFactory;

public abstract class AbstractSslContextFactory
implements ISslContextFactory {
    protected static final List<String> TLS_PROTOCOL_SUBSTITUTION = SSLFactory.tlsInstanceProtocolSubstitution();
    protected boolean openSslIsAvailable;
    protected final Map<String, Object> parameters;
    protected final List<String> cipher_suites;
    protected final String protocol;
    protected final List<String> accepted_protocols;
    protected final String algorithm;
    protected final String store_type;
    protected final boolean require_client_auth;
    protected final boolean require_endpoint_verification;
    protected Boolean enabled;
    protected Boolean optional;

    protected AbstractSslContextFactory() {
        this.parameters = new HashMap<String, Object>();
        this.cipher_suites = null;
        this.protocol = null;
        this.accepted_protocols = null;
        this.algorithm = null;
        this.store_type = "JKS";
        this.require_client_auth = false;
        this.require_endpoint_verification = false;
        this.enabled = null;
        this.optional = null;
        this.deriveIfOpenSslAvailable();
    }

    protected AbstractSslContextFactory(Map<String, Object> parameters) {
        this.parameters = parameters;
        this.cipher_suites = this.getStringList("cipher_suites");
        this.protocol = this.getString("protocol");
        this.accepted_protocols = this.getStringList("accepted_protocols");
        this.algorithm = this.getString("algorithm");
        this.store_type = this.getString("store_type", "JKS");
        this.require_client_auth = this.getBoolean("require_client_auth", false);
        this.require_endpoint_verification = this.getBoolean("require_endpoint_verification", false);
        this.enabled = this.getBoolean("enabled");
        this.optional = this.getBoolean("optional");
        this.deriveIfOpenSslAvailable();
    }

    protected void deriveIfOpenSslAvailable() {
        this.openSslIsAvailable = Boolean.getBoolean("cassandra.disable_tcactive_openssl") ? false : OpenSsl.isAvailable();
    }

    protected String getString(String key, String defaultValue) {
        return this.parameters.get(key) == null ? defaultValue : (String)this.parameters.get(key);
    }

    protected String getString(String key) {
        return (String)this.parameters.get(key);
    }

    protected List<String> getStringList(String key) {
        return (List)this.parameters.get(key);
    }

    protected Boolean getBoolean(String key, boolean defaultValue) {
        return this.parameters.get(key) == null ? defaultValue : (Boolean)this.parameters.get(key);
    }

    protected Boolean getBoolean(String key) {
        return (Boolean)this.parameters.get(key);
    }

    @Override
    public SSLContext createJSSESslContext(boolean verifyPeerCertificate) throws SSLException {
        TrustManager[] trustManagers = null;
        if (verifyPeerCertificate) {
            trustManagers = this.buildTrustManagerFactory().getTrustManagers();
        }
        KeyManagerFactory kmf = this.buildKeyManagerFactory();
        try {
            SSLContext ctx = SSLContext.getInstance("TLS");
            ctx.init(kmf.getKeyManagers(), trustManagers, null);
            return ctx;
        }
        catch (Exception e) {
            throw new SSLException("Error creating/initializing the SSL Context", e);
        }
    }

    @Override
    public SslContext createNettySslContext(boolean verifyPeerCertificate, ISslContextFactory.SocketType socketType, CipherSuiteFilter cipherFilter) throws SSLException {
        KeyManagerFactory kmf = this.buildKeyManagerFactory();
        SslContextBuilder builder = socketType == ISslContextFactory.SocketType.SERVER ? SslContextBuilder.forServer((KeyManagerFactory)kmf).clientAuth(this.require_client_auth ? ClientAuth.REQUIRE : ClientAuth.NONE) : SslContextBuilder.forClient().keyManager(kmf);
        builder.sslProvider(this.getSslProvider()).protocols(this.getAcceptedProtocols());
        if (this.cipher_suites != null && !this.cipher_suites.isEmpty()) {
            builder.ciphers(this.cipher_suites, cipherFilter);
        }
        if (verifyPeerCertificate) {
            builder.trustManager(this.buildTrustManagerFactory());
        }
        return builder.build();
    }

    @Override
    public List<String> getAcceptedProtocols() {
        if (this.accepted_protocols == null) {
            if (this.protocol == null) {
                return null;
            }
            if (this.protocol.equalsIgnoreCase("TLS")) {
                return TLS_PROTOCOL_SUBSTITUTION;
            }
            return ImmutableList.of(this.protocol);
        }
        if (this.protocol != null && !this.protocol.equalsIgnoreCase("TLS") && this.accepted_protocols.stream().noneMatch(ap -> ap.equalsIgnoreCase(this.protocol))) {
            return ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.accepted_protocols)).add(this.protocol)).build();
        }
        return this.accepted_protocols;
    }

    @Override
    public List<String> getCipherSuites() {
        return this.cipher_suites;
    }

    protected SslProvider getSslProvider() {
        return this.openSslIsAvailable ? SslProvider.OPENSSL : SslProvider.JDK;
    }

    protected abstract KeyManagerFactory buildKeyManagerFactory() throws SSLException;

    protected abstract TrustManagerFactory buildTrustManagerFactory() throws SSLException;
}

