/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.schema;

import java.util.Collections;
import java.util.Map;
import net.nmoncho.shaded.com.google.common.collect.MapDifference;
import net.nmoncho.shaded.com.google.common.collect.Maps;
import org.apache.cassandra.schema.KeyspaceMetadata;
import org.apache.cassandra.schema.TableId;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.schema.TableMetadataRef;
import org.apache.cassandra.schema.Tables;
import org.apache.cassandra.schema.ViewMetadata;
import org.apache.cassandra.schema.Views;
import org.apache.cassandra.utils.Pair;

class TableMetadataRefCache {
    public static final TableMetadataRefCache EMPTY = new TableMetadataRefCache(Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap());
    private final Map<TableId, TableMetadataRef> metadataRefs;
    private final Map<Pair<String, String>, TableMetadataRef> metadataRefsByName;
    private final Map<Pair<String, String>, TableMetadataRef> indexMetadataRefs;

    private TableMetadataRefCache(Map<TableId, TableMetadataRef> metadataRefs, Map<Pair<String, String>, TableMetadataRef> metadataRefsByName, Map<Pair<String, String>, TableMetadataRef> indexMetadataRefs) {
        this.metadataRefs = metadataRefs;
        this.metadataRefsByName = metadataRefsByName;
        this.indexMetadataRefs = indexMetadataRefs;
    }

    TableMetadataRefCache withNewRefs(KeyspaceMetadata ksm) {
        return this.withUpdatedRefs(ksm.empty(), ksm);
    }

    TableMetadataRefCache withUpdatedRefs(KeyspaceMetadata previous, KeyspaceMetadata updated) {
        Tables.TablesDiff tablesDiff = Tables.diff(previous.tables, updated.tables);
        Views.ViewsDiff viewsDiff = Views.diff(previous.views, updated.views);
        MapDifference<String, TableMetadata> indexesDiff = previous.tables.indexesDiff(updated.tables);
        boolean hasCreatedOrDroppedTablesOrViews = ((Tables)tablesDiff.created).size() > 0 || ((Tables)tablesDiff.dropped).size() > 0 || ((Views)viewsDiff.created).size() > 0 || ((Views)viewsDiff.dropped).size() > 0;
        boolean hasCreatedOrDroppedIndexes = !indexesDiff.entriesOnlyOnRight().isEmpty() || !indexesDiff.entriesOnlyOnLeft().isEmpty();
        Map<TableId, TableMetadataRef> metadataRefs = hasCreatedOrDroppedTablesOrViews ? Maps.newHashMap(this.metadataRefs) : this.metadataRefs;
        Map<Pair<String, String>, TableMetadataRef> metadataRefsByName = hasCreatedOrDroppedTablesOrViews ? Maps.newHashMap(this.metadataRefsByName) : this.metadataRefsByName;
        Map<Pair<String, String>, TableMetadataRef> indexMetadataRefs = hasCreatedOrDroppedIndexes ? Maps.newHashMap(this.indexMetadataRefs) : this.indexMetadataRefs;
        ((Tables)tablesDiff.dropped).forEach(ref -> this.removeRef(metadataRefs, metadataRefsByName, (TableMetadata)ref));
        ((Views)viewsDiff.dropped).forEach(view -> this.removeRef(metadataRefs, metadataRefsByName, view.metadata));
        indexesDiff.entriesOnlyOnLeft().values().forEach(indexTable -> {
            TableMetadataRef cfr_ignored_0 = (TableMetadataRef)indexMetadataRefs.remove(Pair.create(indexTable.keyspace, indexTable.indexName().get()));
        });
        ((Tables)tablesDiff.created).forEach(table -> this.putRef(metadataRefs, metadataRefsByName, new TableMetadataRef((TableMetadata)table)));
        ((Views)viewsDiff.created).forEach(view -> this.putRef(metadataRefs, metadataRefsByName, new TableMetadataRef(view.metadata)));
        indexesDiff.entriesOnlyOnRight().values().forEach(indexTable -> indexMetadataRefs.put(Pair.create(indexTable.keyspace, indexTable.indexName().get()), new TableMetadataRef((TableMetadata)indexTable)));
        tablesDiff.altered.forEach(diff -> ((TableMetadataRef)metadataRefs.get(((TableMetadata)diff.after).id)).set((TableMetadata)diff.after));
        viewsDiff.altered.forEach(diff -> ((TableMetadataRef)metadataRefs.get(((ViewMetadata)diff.after).metadata.id)).set(((ViewMetadata)diff.after).metadata));
        indexesDiff.entriesDiffering().values().stream().map(MapDifference.ValueDifference::rightValue).forEach(indexTable -> ((TableMetadataRef)indexMetadataRefs.get(Pair.create(indexTable.keyspace, indexTable.indexName().get()))).set((TableMetadata)indexTable));
        return new TableMetadataRefCache(hasCreatedOrDroppedTablesOrViews ? Collections.unmodifiableMap(metadataRefs) : metadataRefs, hasCreatedOrDroppedTablesOrViews ? Collections.unmodifiableMap(metadataRefsByName) : metadataRefsByName, hasCreatedOrDroppedIndexes ? Collections.unmodifiableMap(indexMetadataRefs) : indexMetadataRefs);
    }

    private void putRef(Map<TableId, TableMetadataRef> metadataRefs, Map<Pair<String, String>, TableMetadataRef> metadataRefsByName, TableMetadataRef ref) {
        metadataRefs.put(ref.id, ref);
        metadataRefsByName.put(Pair.create(ref.keyspace, ref.name), ref);
    }

    private void removeRef(Map<TableId, TableMetadataRef> metadataRefs, Map<Pair<String, String>, TableMetadataRef> metadataRefsByName, TableMetadata tm) {
        metadataRefs.remove(tm.id);
        metadataRefsByName.remove(Pair.create(tm.keyspace, tm.name));
    }

    TableMetadataRefCache withRemovedRefs(KeyspaceMetadata ksm) {
        return this.withUpdatedRefs(ksm, ksm.empty());
    }

    public TableMetadataRef getTableMetadataRef(TableId id) {
        return this.metadataRefs.get(id);
    }

    public TableMetadataRef getTableMetadataRef(String keyspace, String table) {
        return this.metadataRefsByName.get(Pair.create(keyspace, table));
    }

    public TableMetadataRef getIndexTableMetadataRef(String keyspace, String index) {
        return this.indexMetadataRefs.get(Pair.create(keyspace, index));
    }
}

