/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.schema;

import net.nmoncho.shaded.com.google.common.collect.MapDifference;
import org.apache.cassandra.diag.DiagnosticEventService;
import org.apache.cassandra.schema.KeyspaceMetadata;
import org.apache.cassandra.schema.Schema;
import org.apache.cassandra.schema.SchemaEvent;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.schema.Tables;
import org.apache.cassandra.schema.Views;

final class SchemaDiagnostics {
    private static final DiagnosticEventService service = DiagnosticEventService.instance();

    private SchemaDiagnostics() {
    }

    static void metadataInitialized(Schema schema, KeyspaceMetadata ksmUpdate) {
        if (SchemaDiagnostics.isEnabled(SchemaEvent.SchemaEventType.KS_METADATA_LOADED)) {
            service.publish(new SchemaEvent(SchemaEvent.SchemaEventType.KS_METADATA_LOADED, schema, ksmUpdate, null, null, null, null, null, null));
        }
    }

    static void metadataReloaded(Schema schema, KeyspaceMetadata previous, KeyspaceMetadata ksmUpdate, Tables.TablesDiff tablesDiff, Views.ViewsDiff viewsDiff, MapDifference<String, TableMetadata> indexesDiff) {
        if (SchemaDiagnostics.isEnabled(SchemaEvent.SchemaEventType.KS_METADATA_RELOADED)) {
            service.publish(new SchemaEvent(SchemaEvent.SchemaEventType.KS_METADATA_RELOADED, schema, ksmUpdate, previous, null, null, tablesDiff, viewsDiff, indexesDiff));
        }
    }

    static void metadataRemoved(Schema schema, KeyspaceMetadata ksmUpdate) {
        if (SchemaDiagnostics.isEnabled(SchemaEvent.SchemaEventType.KS_METADATA_REMOVED)) {
            service.publish(new SchemaEvent(SchemaEvent.SchemaEventType.KS_METADATA_REMOVED, schema, ksmUpdate, null, null, null, null, null, null));
        }
    }

    static void versionUpdated(Schema schema) {
        if (SchemaDiagnostics.isEnabled(SchemaEvent.SchemaEventType.VERSION_UPDATED)) {
            service.publish(new SchemaEvent(SchemaEvent.SchemaEventType.VERSION_UPDATED, schema, null, null, null, null, null, null, null));
        }
    }

    static void keyspaceCreating(Schema schema, KeyspaceMetadata keyspace) {
        if (SchemaDiagnostics.isEnabled(SchemaEvent.SchemaEventType.KS_CREATING)) {
            service.publish(new SchemaEvent(SchemaEvent.SchemaEventType.KS_CREATING, schema, keyspace, null, null, null, null, null, null));
        }
    }

    static void keyspaceCreated(Schema schema, KeyspaceMetadata keyspace) {
        if (SchemaDiagnostics.isEnabled(SchemaEvent.SchemaEventType.KS_CREATED)) {
            service.publish(new SchemaEvent(SchemaEvent.SchemaEventType.KS_CREATED, schema, keyspace, null, null, null, null, null, null));
        }
    }

    static void keyspaceAltering(Schema schema, KeyspaceMetadata.KeyspaceDiff delta) {
        if (SchemaDiagnostics.isEnabled(SchemaEvent.SchemaEventType.KS_ALTERING)) {
            service.publish(new SchemaEvent(SchemaEvent.SchemaEventType.KS_ALTERING, schema, delta.after, delta.before, delta, null, null, null, null));
        }
    }

    static void keyspaceAltered(Schema schema, KeyspaceMetadata.KeyspaceDiff delta) {
        if (SchemaDiagnostics.isEnabled(SchemaEvent.SchemaEventType.KS_ALTERED)) {
            service.publish(new SchemaEvent(SchemaEvent.SchemaEventType.KS_ALTERED, schema, delta.after, delta.before, delta, null, null, null, null));
        }
    }

    static void keyspaceDropping(Schema schema, KeyspaceMetadata keyspace) {
        if (SchemaDiagnostics.isEnabled(SchemaEvent.SchemaEventType.KS_DROPPING)) {
            service.publish(new SchemaEvent(SchemaEvent.SchemaEventType.KS_DROPPING, schema, keyspace, null, null, null, null, null, null));
        }
    }

    static void keyspaceDropped(Schema schema, KeyspaceMetadata keyspace) {
        if (SchemaDiagnostics.isEnabled(SchemaEvent.SchemaEventType.KS_DROPPED)) {
            service.publish(new SchemaEvent(SchemaEvent.SchemaEventType.KS_DROPPED, schema, keyspace, null, null, null, null, null, null));
        }
    }

    static void schemaLoading(Schema schema) {
        if (SchemaDiagnostics.isEnabled(SchemaEvent.SchemaEventType.SCHEMATA_LOADING)) {
            service.publish(new SchemaEvent(SchemaEvent.SchemaEventType.SCHEMATA_LOADING, schema, null, null, null, null, null, null, null));
        }
    }

    static void schemaLoaded(Schema schema) {
        if (SchemaDiagnostics.isEnabled(SchemaEvent.SchemaEventType.SCHEMATA_LOADED)) {
            service.publish(new SchemaEvent(SchemaEvent.SchemaEventType.SCHEMATA_LOADED, schema, null, null, null, null, null, null, null));
        }
    }

    static void versionAnnounced(Schema schema) {
        if (SchemaDiagnostics.isEnabled(SchemaEvent.SchemaEventType.VERSION_ANOUNCED)) {
            service.publish(new SchemaEvent(SchemaEvent.SchemaEventType.VERSION_ANOUNCED, schema, null, null, null, null, null, null, null));
        }
    }

    static void schemaCleared(Schema schema) {
        if (SchemaDiagnostics.isEnabled(SchemaEvent.SchemaEventType.SCHEMATA_CLEARED)) {
            service.publish(new SchemaEvent(SchemaEvent.SchemaEventType.SCHEMATA_CLEARED, schema, null, null, null, null, null, null, null));
        }
    }

    static void tableCreating(Schema schema, TableMetadata table) {
        if (SchemaDiagnostics.isEnabled(SchemaEvent.SchemaEventType.TABLE_CREATING)) {
            service.publish(new SchemaEvent(SchemaEvent.SchemaEventType.TABLE_CREATING, schema, null, null, null, table, null, null, null));
        }
    }

    static void tableCreated(Schema schema, TableMetadata table) {
        if (SchemaDiagnostics.isEnabled(SchemaEvent.SchemaEventType.TABLE_CREATED)) {
            service.publish(new SchemaEvent(SchemaEvent.SchemaEventType.TABLE_CREATED, schema, null, null, null, table, null, null, null));
        }
    }

    static void tableAltering(Schema schema, TableMetadata table) {
        if (SchemaDiagnostics.isEnabled(SchemaEvent.SchemaEventType.TABLE_ALTERING)) {
            service.publish(new SchemaEvent(SchemaEvent.SchemaEventType.TABLE_ALTERING, schema, null, null, null, table, null, null, null));
        }
    }

    static void tableAltered(Schema schema, TableMetadata table) {
        if (SchemaDiagnostics.isEnabled(SchemaEvent.SchemaEventType.TABLE_ALTERED)) {
            service.publish(new SchemaEvent(SchemaEvent.SchemaEventType.TABLE_ALTERED, schema, null, null, null, table, null, null, null));
        }
    }

    static void tableDropping(Schema schema, TableMetadata table) {
        if (SchemaDiagnostics.isEnabled(SchemaEvent.SchemaEventType.TABLE_DROPPING)) {
            service.publish(new SchemaEvent(SchemaEvent.SchemaEventType.TABLE_DROPPING, schema, null, null, null, table, null, null, null));
        }
    }

    static void tableDropped(Schema schema, TableMetadata table) {
        if (SchemaDiagnostics.isEnabled(SchemaEvent.SchemaEventType.TABLE_DROPPED)) {
            service.publish(new SchemaEvent(SchemaEvent.SchemaEventType.TABLE_DROPPED, schema, null, null, null, table, null, null, null));
        }
    }

    private static boolean isEnabled(SchemaEvent.SchemaEventType type) {
        return service.isEnabled(SchemaEvent.class, type);
    }
}

