/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.schema;

import java.util.HashMap;
import java.util.Map;
import net.nmoncho.shaded.com.google.common.base.MoreObjects;
import net.nmoncho.shaded.com.google.common.base.Objects;
import net.nmoncho.shaded.com.google.common.collect.ImmutableMap;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.cql3.CqlBuilder;
import org.apache.cassandra.locator.AbstractReplicationStrategy;
import org.apache.cassandra.locator.IEndpointSnitch;
import org.apache.cassandra.locator.LocalStrategy;
import org.apache.cassandra.locator.NetworkTopologyStrategy;
import org.apache.cassandra.locator.SimpleStrategy;
import org.apache.cassandra.locator.TokenMetadata;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.StorageService;

public final class ReplicationParams {
    public static final String CLASS = "class";
    public final Class<? extends AbstractReplicationStrategy> klass;
    public final ImmutableMap<String, String> options;

    private ReplicationParams(Class<? extends AbstractReplicationStrategy> klass, Map<String, String> options) {
        this.klass = klass;
        this.options = ImmutableMap.copyOf(options);
    }

    static ReplicationParams local() {
        return new ReplicationParams(LocalStrategy.class, ImmutableMap.of());
    }

    static ReplicationParams simple(int replicationFactor) {
        return new ReplicationParams(SimpleStrategy.class, ImmutableMap.of("replication_factor", Integer.toString(replicationFactor)));
    }

    static ReplicationParams simple(String replicationFactor) {
        return new ReplicationParams(SimpleStrategy.class, ImmutableMap.of("replication_factor", replicationFactor));
    }

    static ReplicationParams nts(Object ... args) {
        assert (args.length % 2 == 0);
        HashMap<String, String> options = new HashMap<String, String>();
        for (int i = 0; i < args.length; i += 2) {
            options.put((String)args[i], args[i + 1].toString());
        }
        return new ReplicationParams(NetworkTopologyStrategy.class, options);
    }

    public void validate(String name, ClientState state) {
        TokenMetadata tmd = StorageService.instance.getTokenMetadata();
        IEndpointSnitch eps = DatabaseDescriptor.getEndpointSnitch();
        AbstractReplicationStrategy.validateReplicationStrategy(name, this.klass, tmd, eps, this.options, state);
    }

    public static ReplicationParams fromMap(Map<String, String> map) {
        return ReplicationParams.fromMapWithDefaults(map, new HashMap<String, String>());
    }

    public static ReplicationParams fromMapWithDefaults(Map<String, String> map, Map<String, String> previousOptions) {
        HashMap<String, String> options = new HashMap<String, String>(map);
        String className = (String)options.remove(CLASS);
        Class<AbstractReplicationStrategy> klass = AbstractReplicationStrategy.getClass(className);
        AbstractReplicationStrategy.prepareReplicationStrategyOptions(klass, options, previousOptions);
        return new ReplicationParams(klass, options);
    }

    public Map<String, String> asMap() {
        HashMap<String, String> map = new HashMap<String, String>(this.options);
        map.put(CLASS, this.klass.getName());
        return map;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ReplicationParams)) {
            return false;
        }
        ReplicationParams r = (ReplicationParams)o;
        return this.klass.equals(r.klass) && this.options.equals(r.options);
    }

    public int hashCode() {
        return Objects.hashCode(this.klass, this.options);
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(this);
        helper.add(CLASS, this.klass.getName());
        for (Map.Entry entry : this.options.entrySet()) {
            helper.add((String)entry.getKey(), entry.getValue());
        }
        return helper.toString();
    }

    public void appendCqlTo(CqlBuilder builder) {
        String classname = "org.apache.cassandra.locator".equals(this.klass.getPackage().getName()) ? this.klass.getSimpleName() : this.klass.getName();
        builder.append("{'class': ").appendWithSingleQuotes(classname);
        this.options.forEach((k, v) -> builder.append(", ").appendWithSingleQuotes((String)k).append(": ").appendWithSingleQuotes((String)v));
        builder.append('}');
    }
}

