/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.schema;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.nmoncho.shaded.com.google.common.collect.ImmutableCollection;
import net.nmoncho.shaded.com.google.common.collect.ImmutableList;
import net.nmoncho.shaded.com.google.common.collect.ImmutableMap;
import net.nmoncho.shaded.com.google.common.collect.ImmutableSet;
import net.nmoncho.shaded.com.google.common.collect.Iterables;
import org.apache.cassandra.schema.KeyspaceMetadata;
import org.apache.cassandra.schema.TableId;
import org.apache.cassandra.schema.TableMetadata;

public final class Keyspaces
implements Iterable<KeyspaceMetadata> {
    private static final Keyspaces NONE = Keyspaces.builder().build();
    private final ImmutableMap<String, KeyspaceMetadata> keyspaces;
    private final ImmutableMap<TableId, TableMetadata> tables;

    private Keyspaces(Builder builder) {
        this.keyspaces = builder.keyspaces.build();
        this.tables = builder.tables.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Keyspaces none() {
        return NONE;
    }

    public static Keyspaces of(KeyspaceMetadata ... keyspaces) {
        return Keyspaces.builder().add(keyspaces).build();
    }

    @Override
    public Iterator<KeyspaceMetadata> iterator() {
        return ((ImmutableCollection)this.keyspaces.values()).iterator();
    }

    public Stream<KeyspaceMetadata> stream() {
        return this.keyspaces.values().stream();
    }

    public ImmutableSet<String> names() {
        return this.keyspaces.keySet();
    }

    public Optional<KeyspaceMetadata> get(String name) {
        return Optional.ofNullable(this.keyspaces.get(name));
    }

    @Nullable
    public KeyspaceMetadata getNullable(String name) {
        return this.keyspaces.get(name);
    }

    public boolean containsKeyspace(String name) {
        return this.keyspaces.containsKey(name);
    }

    @Nullable
    public TableMetadata getTableOrViewNullable(TableId id) {
        return this.tables.get(id);
    }

    public boolean isEmpty() {
        return this.keyspaces.isEmpty();
    }

    public Keyspaces filter(Predicate<KeyspaceMetadata> predicate) {
        Builder builder = Keyspaces.builder();
        this.stream().filter(predicate).forEach(builder::add);
        return builder.build();
    }

    public Keyspaces without(String name) {
        KeyspaceMetadata keyspace = this.getNullable(name);
        if (keyspace == null) {
            throw new IllegalStateException(String.format("Keyspace %s doesn't exists", name));
        }
        return this.filter(k -> k != keyspace);
    }

    public Keyspaces without(Collection<String> names) {
        return this.filter(k -> !names.contains(k.name));
    }

    public Keyspaces withAddedOrUpdated(KeyspaceMetadata keyspace) {
        return Keyspaces.builder().add(Iterables.filter(this, k -> !k.name.equals(keyspace.name))).add(keyspace).build();
    }

    public Keyspaces withAddedOrReplaced(KeyspaceMetadata keyspace) {
        return Keyspaces.builder().add(Iterables.filter(this, k -> !k.name.equals(keyspace.name))).add(keyspace).build();
    }

    public Keyspaces withAddedOrReplaced(Keyspaces keyspaces) {
        return Keyspaces.builder().add(Iterables.filter(this, k -> !keyspaces.containsKeyspace(k.name))).add(keyspaces).build();
    }

    public void validate() {
        this.keyspaces.values().forEach(KeyspaceMetadata::validate);
    }

    public boolean equals(Object o) {
        return this == o || o instanceof Keyspaces && this.keyspaces.equals(((Keyspaces)o).keyspaces);
    }

    public int hashCode() {
        return this.keyspaces.hashCode();
    }

    public String toString() {
        return ((AbstractCollection)this.keyspaces.values()).toString();
    }

    public int size() {
        return this.keyspaces.size();
    }

    public static KeyspacesDiff diff(Keyspaces before, Keyspaces after) {
        return KeyspacesDiff.diff(before, after);
    }

    public static final class KeyspacesDiff {
        public static final KeyspacesDiff NONE = new KeyspacesDiff(Keyspaces.none(), Keyspaces.none(), ImmutableList.of());
        public final Keyspaces created;
        public final Keyspaces dropped;
        public final ImmutableList<KeyspaceMetadata.KeyspaceDiff> altered;

        private KeyspacesDiff(Keyspaces created, Keyspaces dropped, ImmutableList<KeyspaceMetadata.KeyspaceDiff> altered) {
            this.created = created;
            this.dropped = dropped;
            this.altered = altered;
        }

        private static KeyspacesDiff diff(Keyspaces before, Keyspaces after) {
            if (before == after) {
                return NONE;
            }
            Keyspaces created = after.filter(k -> !before.containsKeyspace(k.name));
            Keyspaces dropped = before.filter(k -> !after.containsKeyspace(k.name));
            ImmutableList.Builder altered = ImmutableList.builder();
            before.forEach(keyspaceBefore -> {
                KeyspaceMetadata keyspaceAfter = after.getNullable(keyspaceBefore.name);
                if (null != keyspaceAfter) {
                    KeyspaceMetadata.diff(keyspaceBefore, keyspaceAfter).ifPresent(altered::add);
                }
            });
            return new KeyspacesDiff(created, dropped, (ImmutableList<KeyspaceMetadata.KeyspaceDiff>)altered.build());
        }

        public boolean isEmpty() {
            return this.created.isEmpty() && this.dropped.isEmpty() && this.altered.isEmpty();
        }

        public String toString() {
            return "KeyspacesDiff{created=" + this.created + ", dropped=" + this.dropped + ", altered=" + this.altered + '}';
        }
    }

    public static final class Builder {
        private final ImmutableMap.Builder<String, KeyspaceMetadata> keyspaces = new ImmutableMap.Builder();
        private final ImmutableMap.Builder<TableId, TableMetadata> tables = new ImmutableMap.Builder();

        private Builder() {
        }

        public Keyspaces build() {
            return new Keyspaces(this);
        }

        public Builder add(KeyspaceMetadata keyspace) {
            this.keyspaces.put(keyspace.name, keyspace);
            keyspace.tables.forEach(t -> this.tables.put(t.id, (TableMetadata)t));
            keyspace.views.forEach(v -> this.tables.put(v.metadata.id, v.metadata));
            return this;
        }

        public Builder add(KeyspaceMetadata ... keyspaces) {
            for (KeyspaceMetadata keyspace : keyspaces) {
                this.add(keyspace);
            }
            return this;
        }

        public Builder add(Iterable<KeyspaceMetadata> keyspaces) {
            keyspaces.forEach(this::add);
            return this;
        }
    }
}

