/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.schema;

import java.util.Objects;
import java.util.UUID;
import net.nmoncho.shaded.com.google.common.base.Preconditions;
import org.apache.cassandra.schema.Keyspaces;
import org.apache.cassandra.schema.SchemaConstants;

public class DistributedSchema {
    public static final DistributedSchema EMPTY = new DistributedSchema(Keyspaces.none(), SchemaConstants.emptyVersion);
    private final Keyspaces keyspaces;
    private final UUID version;

    public DistributedSchema(Keyspaces keyspaces, UUID version) {
        Objects.requireNonNull(keyspaces);
        Objects.requireNonNull(version);
        this.keyspaces = keyspaces;
        this.version = version;
        this.validate();
    }

    public Keyspaces getKeyspaces() {
        return this.keyspaces;
    }

    public boolean isEmpty() {
        return SchemaConstants.emptyVersion.equals(this.version);
    }

    public UUID getVersion() {
        return this.version;
    }

    public static String schemaVersionToString(UUID version) {
        return version == null ? "unknown" : (SchemaConstants.emptyVersion.equals(version) ? "(empty)" : version.toString());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DistributedSchema schema = (DistributedSchema)o;
        return this.keyspaces.equals(schema.keyspaces) && this.version.equals(schema.version);
    }

    public int hashCode() {
        return Objects.hash(this.keyspaces, this.version);
    }

    private void validate() {
        this.keyspaces.forEach(ksm -> {
            ksm.tables.forEach(tm -> Preconditions.checkArgument(tm.keyspace.equals(ksm.name), "Table %s metadata points to keyspace %s while defined in keyspace %s", (Object)tm.name, (Object)tm.keyspace, (Object)ksm.name));
            ksm.views.forEach(vm -> Preconditions.checkArgument(vm.keyspace().equals(ksm.name), "View %s metadata points to keyspace %s while defined in keyspace %s", (Object)vm.name(), (Object)vm.keyspace(), (Object)ksm.name));
            ksm.types.forEach(ut -> Preconditions.checkArgument(ut.keyspace.equals(ksm.name), "Type %s points to keyspace %s while defined in keyspace %s", (Object)ut.name, (Object)ut.keyspace, (Object)ksm.name));
            ksm.functions.forEach(f -> Preconditions.checkArgument(f.name().keyspace.equals(ksm.name), "Function %s points to keyspace %s while defined in keyspace %s", (Object)f.name().name, (Object)f.name().keyspace, (Object)ksm.name));
        });
    }
}

