/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.schema;

import java.util.HashMap;
import java.util.Map;
import net.nmoncho.shaded.com.google.common.annotations.VisibleForTesting;
import net.nmoncho.shaded.com.google.common.base.Objects;
import net.nmoncho.shaded.com.google.common.collect.ImmutableMap;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.commons.lang3.StringUtils;

public final class CachingParams {
    private static final String ALL = "ALL";
    private static final String NONE = "NONE";
    static final boolean DEFAULT_CACHE_KEYS = true;
    static final int DEFAULT_ROWS_PER_PARTITION_TO_CACHE = 0;
    public static final CachingParams CACHE_NOTHING = new CachingParams(false, 0);
    public static final CachingParams CACHE_KEYS = new CachingParams(true, 0);
    public static final CachingParams CACHE_EVERYTHING = new CachingParams(true, Integer.MAX_VALUE);
    @VisibleForTesting
    public static CachingParams DEFAULT = new CachingParams(true, 0);
    final boolean cacheKeys;
    final int rowsPerPartitionToCache;

    public CachingParams(boolean cacheKeys, int rowsPerPartitionToCache) {
        this.cacheKeys = cacheKeys;
        this.rowsPerPartitionToCache = rowsPerPartitionToCache;
    }

    public boolean cacheKeys() {
        return this.cacheKeys;
    }

    public boolean cacheRows() {
        return this.rowsPerPartitionToCache > 0;
    }

    public boolean cacheAllRows() {
        return this.rowsPerPartitionToCache == Integer.MAX_VALUE;
    }

    public int rowsPerPartitionToCache() {
        return this.rowsPerPartitionToCache;
    }

    public static CachingParams fromMap(Map<String, String> map) {
        int rowsPerPartitionToCache;
        HashMap<String, String> copy = new HashMap<String, String>(map);
        String keys = (String)copy.remove(Option.KEYS.toString());
        boolean cacheKeys = keys != null && CachingParams.keysFromString(keys);
        String rows = (String)copy.remove(Option.ROWS_PER_PARTITION.toString());
        int n = rowsPerPartitionToCache = rows == null ? 0 : CachingParams.rowsPerPartitionFromString(rows);
        if (!copy.isEmpty()) {
            throw new ConfigurationException(String.format("Invalid caching sub-options %s: only '%s' and '%s' are allowed", new Object[]{copy.keySet(), Option.KEYS, Option.ROWS_PER_PARTITION}));
        }
        return new CachingParams(cacheKeys, rowsPerPartitionToCache);
    }

    public Map<String, String> asMap() {
        return ImmutableMap.of(Option.KEYS.toString(), this.keysAsString(), Option.ROWS_PER_PARTITION.toString(), this.rowsPerPartitionAsString());
    }

    private static boolean keysFromString(String value) {
        if (value.equalsIgnoreCase(ALL)) {
            return true;
        }
        if (value.equalsIgnoreCase(NONE)) {
            return false;
        }
        throw new ConfigurationException(String.format("Invalid value '%s' for caching sub-option '%s': only '%s' and '%s' are allowed", new Object[]{value, Option.KEYS, ALL, NONE}));
    }

    String keysAsString() {
        return this.cacheKeys ? ALL : NONE;
    }

    private static int rowsPerPartitionFromString(String value) {
        if (value.equalsIgnoreCase(ALL)) {
            return Integer.MAX_VALUE;
        }
        if (value.equalsIgnoreCase(NONE)) {
            return 0;
        }
        if (StringUtils.isNumeric((CharSequence)value)) {
            return Integer.parseInt(value);
        }
        throw new ConfigurationException(String.format("Invalid value '%s' for caching sub-option '%s': only '%s', '%s', and integer values are allowed", new Object[]{value, Option.ROWS_PER_PARTITION, ALL, NONE}));
    }

    String rowsPerPartitionAsString() {
        if (this.rowsPerPartitionToCache == 0) {
            return NONE;
        }
        if (this.rowsPerPartitionToCache == Integer.MAX_VALUE) {
            return ALL;
        }
        return Integer.toString(this.rowsPerPartitionToCache);
    }

    public String toString() {
        return String.format("{'%s' : '%s', '%s' : '%s'}", new Object[]{Option.KEYS, this.keysAsString(), Option.ROWS_PER_PARTITION, this.rowsPerPartitionAsString()});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CachingParams)) {
            return false;
        }
        CachingParams c = (CachingParams)o;
        return this.cacheKeys == c.cacheKeys && this.rowsPerPartitionToCache == c.rowsPerPartitionToCache;
    }

    public int hashCode() {
        return Objects.hashCode(this.cacheKeys, this.rowsPerPartitionToCache);
    }

    public static enum Option {
        KEYS,
        ROWS_PER_PARTITION;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

