/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.schema;

import net.nmoncho.shaded.com.google.common.collect.ImmutableSet;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.CQLFragmentParser;
import org.apache.cassandra.cql3.CqlParser;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.UserType;
import org.apache.cassandra.schema.Types;
import org.apache.cassandra.utils.ByteBufferUtil;

public final class CQLTypeParser {
    private static final ImmutableSet<String> PRIMITIVE_TYPES;

    public static AbstractType<?> parse(String keyspace, String unparsed, Types userTypes) {
        String lowercased = unparsed.toLowerCase();
        if (PRIMITIVE_TYPES.contains(lowercased)) {
            return CQL3Type.Native.valueOf(unparsed.toUpperCase()).getType();
        }
        UserType udt = userTypes.getNullable(ByteBufferUtil.bytes(lowercased));
        if (udt != null) {
            return udt;
        }
        return CQLTypeParser.parseRaw(unparsed).prepareInternal(keyspace, userTypes).getType();
    }

    static CQL3Type.Raw parseRaw(String type) {
        return CQLFragmentParser.parseAny(CqlParser::comparatorType, type, "CQL type");
    }

    static {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (CQL3Type.Native primitive : CQL3Type.Native.values()) {
            builder.add(primitive.name().toLowerCase());
        }
        PRIMITIVE_TYPES = builder.build();
    }
}

