/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair.state;

import java.util.Set;
import java.util.UUID;
import net.nmoncho.shaded.com.google.common.collect.ImmutableSet;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.repair.RepairJobDesc;
import org.apache.cassandra.repair.state.AbstractCompletable;
import org.apache.cassandra.repair.state.AbstractState;

public class JobState
extends AbstractState<State, UUID> {
    public final RepairJobDesc desc;
    private final ImmutableSet<InetAddressAndPort> endpoints;
    public final Phase phase = new Phase();

    public JobState(RepairJobDesc desc, ImmutableSet<InetAddressAndPort> endpoints) {
        super(desc.determanisticId(), State.class);
        this.desc = desc;
        this.endpoints = endpoints;
    }

    public Set<InetAddressAndPort> getParticipants() {
        return this.endpoints;
    }

    public final class Phase
    extends AbstractCompletable.BasePhase {
        public void start() {
            JobState.this.updateState(State.START);
        }

        public void snapshotsSubmitted() {
            JobState.this.updateState(State.SNAPSHOT_START);
        }

        public void snapshotsCompleted() {
            JobState.this.updateState(State.SNAPSHOT_COMPLETE);
        }

        public void validationSubmitted() {
            JobState.this.updateState(State.VALIDATION_START);
        }

        public void validationCompleted() {
            JobState.this.updateState(State.VALIDATION_COMPLETE);
        }

        public void streamSubmitted() {
            JobState.this.updateState(State.STREAM_START);
        }
    }

    public static enum State {
        START,
        SNAPSHOT_START,
        SNAPSHOT_COMPLETE,
        VALIDATION_START,
        VALIDATION_COMPLETE,
        STREAM_START;

    }
}

