/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair.messages;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import net.nmoncho.shaded.com.google.common.base.Joiner;
import net.nmoncho.shaded.com.google.common.base.Preconditions;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.repair.RepairParallelism;
import org.apache.cassandra.streaming.PreviewKind;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepairOption {
    public static final String PARALLELISM_KEY = "parallelism";
    public static final String PRIMARY_RANGE_KEY = "primaryRange";
    public static final String INCREMENTAL_KEY = "incremental";
    public static final String JOB_THREADS_KEY = "jobThreads";
    public static final String RANGES_KEY = "ranges";
    public static final String COLUMNFAMILIES_KEY = "columnFamilies";
    public static final String DATACENTERS_KEY = "dataCenters";
    public static final String HOSTS_KEY = "hosts";
    public static final String TRACE_KEY = "trace";
    public static final String SUB_RANGE_REPAIR_KEY = "sub_range_repair";
    public static final String PULL_REPAIR_KEY = "pullRepair";
    public static final String FORCE_REPAIR_KEY = "forceRepair";
    public static final String PREVIEW = "previewKind";
    public static final String OPTIMISE_STREAMS_KEY = "optimiseStreams";
    public static final String IGNORE_UNREPLICATED_KS = "ignoreUnreplicatedKeyspaces";
    public static final String REPAIR_PAXOS_KEY = "repairPaxos";
    public static final String PAXOS_ONLY_KEY = "paxosOnly";
    public static final int MAX_JOB_THREADS = 4;
    private static final Logger logger = LoggerFactory.getLogger(RepairOption.class);
    private final RepairParallelism parallelism;
    private final boolean primaryRange;
    private final boolean incremental;
    private final boolean trace;
    private final int jobThreads;
    private final boolean isSubrangeRepair;
    private final boolean pullRepair;
    private final boolean forceRepair;
    private final PreviewKind previewKind;
    private final boolean optimiseStreams;
    private final boolean ignoreUnreplicatedKeyspaces;
    private final boolean repairPaxos;
    private final boolean paxosOnly;
    private final Collection<String> columnFamilies = new HashSet<String>();
    private final Collection<String> dataCenters = new HashSet<String>();
    private final Collection<String> hosts = new HashSet<String>();
    private final Collection<Range<Token>> ranges = new HashSet<Range<Token>>();

    public static Set<Range<Token>> parseRanges(String rangesStr, IPartitioner partitioner) {
        if (rangesStr == null || rangesStr.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<Range<Token>> ranges = new HashSet<Range<Token>>();
        StringTokenizer tokenizer = new StringTokenizer(rangesStr, ",");
        while (tokenizer.hasMoreTokens()) {
            Token parsedEndToken;
            String[] rangeStr = tokenizer.nextToken().split(":", 2);
            if (rangeStr.length < 2) continue;
            Token parsedBeginToken = partitioner.getTokenFactory().fromString(rangeStr[0].trim());
            if (parsedBeginToken.equals(parsedEndToken = partitioner.getTokenFactory().fromString(rangeStr[1].trim()))) {
                throw new IllegalArgumentException("Start and end tokens must be different.");
            }
            ranges.add(new Range<Token>(parsedBeginToken, parsedEndToken));
        }
        return ranges;
    }

    public static RepairOption parse(Map<String, String> options, IPartitioner partitioner) {
        String cfStr;
        RepairParallelism parallelism = RepairParallelism.fromName(options.get(PARALLELISM_KEY));
        boolean primaryRange = Boolean.parseBoolean(options.get(PRIMARY_RANGE_KEY));
        boolean incremental = Boolean.parseBoolean(options.get(INCREMENTAL_KEY));
        PreviewKind previewKind = PreviewKind.valueOf(options.getOrDefault(PREVIEW, PreviewKind.NONE.toString()));
        boolean trace = Boolean.parseBoolean(options.get(TRACE_KEY));
        boolean force = Boolean.parseBoolean(options.get(FORCE_REPAIR_KEY));
        boolean pullRepair = Boolean.parseBoolean(options.get(PULL_REPAIR_KEY));
        boolean ignoreUnreplicatedKeyspaces = Boolean.parseBoolean(options.get(IGNORE_UNREPLICATED_KS));
        boolean repairPaxos = Boolean.parseBoolean(options.get(REPAIR_PAXOS_KEY));
        boolean paxosOnly = Boolean.parseBoolean(options.get(PAXOS_ONLY_KEY));
        if (previewKind != PreviewKind.NONE) {
            Preconditions.checkArgument(!repairPaxos, "repairPaxos must be set to false for preview repairs");
            Preconditions.checkArgument(!paxosOnly, "paxosOnly must be set to false for preview repairs");
        }
        int jobThreads = 1;
        if (options.containsKey(JOB_THREADS_KEY)) {
            try {
                jobThreads = Integer.parseInt(options.get(JOB_THREADS_KEY));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        Set<Range<Token>> ranges = RepairOption.parseRanges(options.get(RANGES_KEY), partitioner);
        boolean asymmetricSyncing = Boolean.parseBoolean(options.get(OPTIMISE_STREAMS_KEY));
        RepairOption option = new RepairOption(parallelism, primaryRange, incremental, trace, jobThreads, ranges, !ranges.isEmpty(), pullRepair, force, previewKind, asymmetricSyncing, ignoreUnreplicatedKeyspaces, repairPaxos, paxosOnly);
        String dataCentersStr = options.get(DATACENTERS_KEY);
        HashSet<String> dataCenters = new HashSet<String>();
        if (dataCentersStr != null) {
            StringTokenizer tokenizer = new StringTokenizer(dataCentersStr, ",");
            while (tokenizer.hasMoreTokens()) {
                dataCenters.add(tokenizer.nextToken().trim());
            }
            option.getDataCenters().addAll(dataCenters);
        }
        String hostsStr = options.get(HOSTS_KEY);
        HashSet<String> hosts = new HashSet<String>();
        if (hostsStr != null) {
            StringTokenizer tokenizer = new StringTokenizer(hostsStr, ",");
            while (tokenizer.hasMoreTokens()) {
                hosts.add(tokenizer.nextToken().trim());
            }
            option.getHosts().addAll(hosts);
        }
        if ((cfStr = options.get(COLUMNFAMILIES_KEY)) != null) {
            HashSet<String> columnFamilies = new HashSet<String>();
            StringTokenizer tokenizer = new StringTokenizer(cfStr, ",");
            while (tokenizer.hasMoreTokens()) {
                columnFamilies.add(tokenizer.nextToken().trim());
            }
            option.getColumnFamilies().addAll(columnFamilies);
        }
        if (jobThreads > 4) {
            throw new IllegalArgumentException("Too many job threads. Max is 4");
        }
        if (!dataCenters.isEmpty() && !hosts.isEmpty()) {
            throw new IllegalArgumentException("Cannot combine -dc and -hosts options.");
        }
        if (primaryRange && (!dataCenters.isEmpty() && !option.isInLocalDCOnly() || !hosts.isEmpty())) {
            throw new IllegalArgumentException("You need to run primary range repair on all nodes in the cluster.");
        }
        if (pullRepair) {
            if (hosts.size() != 2) {
                throw new IllegalArgumentException("Pull repair can only be performed between two hosts. Please specify two hosts, one of which must be this host.");
            }
            if (ranges.isEmpty()) {
                throw new IllegalArgumentException("Token ranges must be specified when performing pull repair. Please specify at least one token range which both hosts have in common.");
            }
        }
        return option;
    }

    public RepairOption(RepairParallelism parallelism, boolean primaryRange, boolean incremental, boolean trace, int jobThreads, Collection<Range<Token>> ranges, boolean isSubrangeRepair, boolean pullRepair, boolean forceRepair, PreviewKind previewKind, boolean optimiseStreams, boolean ignoreUnreplicatedKeyspaces, boolean repairPaxos, boolean paxosOnly) {
        this.parallelism = parallelism;
        this.primaryRange = primaryRange;
        this.incremental = incremental;
        this.trace = trace;
        this.jobThreads = jobThreads;
        this.ranges.addAll(ranges);
        this.isSubrangeRepair = isSubrangeRepair;
        this.pullRepair = pullRepair;
        this.forceRepair = forceRepair;
        this.previewKind = previewKind;
        this.optimiseStreams = optimiseStreams;
        this.ignoreUnreplicatedKeyspaces = ignoreUnreplicatedKeyspaces;
        this.repairPaxos = repairPaxos;
        this.paxosOnly = paxosOnly;
    }

    public RepairParallelism getParallelism() {
        return this.parallelism;
    }

    public boolean isPrimaryRange() {
        return this.primaryRange;
    }

    public boolean isIncremental() {
        return this.incremental;
    }

    public boolean isTraced() {
        return this.trace;
    }

    public boolean isPullRepair() {
        return this.pullRepair;
    }

    public boolean isForcedRepair() {
        return this.forceRepair;
    }

    public int getJobThreads() {
        return this.jobThreads;
    }

    public Collection<String> getColumnFamilies() {
        return this.columnFamilies;
    }

    public Collection<Range<Token>> getRanges() {
        return this.ranges;
    }

    public Collection<String> getDataCenters() {
        return this.dataCenters;
    }

    public Collection<String> getHosts() {
        return this.hosts;
    }

    public boolean isGlobal() {
        return this.dataCenters.isEmpty() && this.hosts.isEmpty();
    }

    public boolean isSubrangeRepair() {
        return this.isSubrangeRepair;
    }

    public PreviewKind getPreviewKind() {
        return this.previewKind;
    }

    public boolean isPreview() {
        return this.previewKind.isPreview();
    }

    public boolean isInLocalDCOnly() {
        return this.dataCenters.size() == 1 && this.dataCenters.contains(DatabaseDescriptor.getLocalDataCenter());
    }

    public boolean optimiseStreams() {
        if (this.optimiseStreams) {
            return true;
        }
        if (this.isPullRepair() || this.isForcedRepair()) {
            return false;
        }
        if (this.isIncremental() && DatabaseDescriptor.autoOptimiseIncRepairStreams()) {
            return true;
        }
        if (this.isPreview() && DatabaseDescriptor.autoOptimisePreviewRepairStreams()) {
            return true;
        }
        return !this.isIncremental() && DatabaseDescriptor.autoOptimiseFullRepairStreams();
    }

    public boolean ignoreUnreplicatedKeyspaces() {
        return this.ignoreUnreplicatedKeyspaces;
    }

    public boolean repairPaxos() {
        return this.repairPaxos;
    }

    public boolean paxosOnly() {
        return this.paxosOnly;
    }

    public String toString() {
        return "repair options (parallelism: " + (Object)((Object)this.parallelism) + ", primary range: " + this.primaryRange + ", incremental: " + this.incremental + ", job threads: " + this.jobThreads + ", ColumnFamilies: " + this.columnFamilies + ", dataCenters: " + this.dataCenters + ", hosts: " + this.hosts + ", previewKind: " + (Object)((Object)this.previewKind) + ", # of ranges: " + this.ranges.size() + ", pull repair: " + this.pullRepair + ", force repair: " + this.forceRepair + ", optimise streams: " + this.optimiseStreams() + ", ignore unreplicated keyspaces: " + this.ignoreUnreplicatedKeyspaces + ", repairPaxos: " + this.repairPaxos + ", paxosOnly: " + this.paxosOnly + ')';
    }

    public Map<String, String> asMap() {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put(PARALLELISM_KEY, this.parallelism.toString());
        options.put(PRIMARY_RANGE_KEY, Boolean.toString(this.primaryRange));
        options.put(INCREMENTAL_KEY, Boolean.toString(this.incremental));
        options.put(JOB_THREADS_KEY, Integer.toString(this.jobThreads));
        options.put(COLUMNFAMILIES_KEY, Joiner.on(",").join(this.columnFamilies));
        options.put(DATACENTERS_KEY, Joiner.on(",").join(this.dataCenters));
        options.put(HOSTS_KEY, Joiner.on(",").join(this.hosts));
        options.put(SUB_RANGE_REPAIR_KEY, Boolean.toString(this.isSubrangeRepair));
        options.put(TRACE_KEY, Boolean.toString(this.trace));
        options.put(RANGES_KEY, Joiner.on(",").join(this.ranges));
        options.put(PULL_REPAIR_KEY, Boolean.toString(this.pullRepair));
        options.put(FORCE_REPAIR_KEY, Boolean.toString(this.forceRepair));
        options.put(PREVIEW, this.previewKind.toString());
        options.put(OPTIMISE_STREAMS_KEY, Boolean.toString(this.optimiseStreams));
        options.put(REPAIR_PAXOS_KEY, Boolean.toString(this.repairPaxos));
        options.put(PAXOS_ONLY_KEY, Boolean.toString(this.paxosOnly));
        return options;
    }
}

