/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair.messages;

import org.apache.cassandra.exceptions.RepairException;
import org.apache.cassandra.exceptions.RequestFailureReason;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessageFlag;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.net.RequestCallback;
import org.apache.cassandra.net.Verb;
import org.apache.cassandra.repair.RepairJobDesc;
import org.apache.cassandra.streaming.PreviewKind;
import org.apache.cassandra.utils.CassandraVersion;
import org.apache.cassandra.utils.TimeUUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RepairMessage {
    private static final CassandraVersion SUPPORTS_TIMEOUTS = new CassandraVersion("4.0.7-SNAPSHOT");
    private static final Logger logger = LoggerFactory.getLogger(RepairMessage.class);
    public final RepairJobDesc desc;

    protected RepairMessage(RepairJobDesc desc) {
        this.desc = desc;
    }

    public static void sendMessageWithFailureCB(final RepairMessage request, final Verb verb, final InetAddressAndPort endpoint, final RepairFailureCallback failureCallback) {
        RequestCallback<Object> callback = new RequestCallback<Object>(){

            @Override
            public void onResponse(Message<Object> msg) {
                logger.info("[#{}] {} received by {}", new Object[]{request.desc.parentSessionId, verb, endpoint});
            }

            @Override
            public boolean invokeOnFailure() {
                return true;
            }

            @Override
            public void onFailure(InetAddressAndPort from, RequestFailureReason failureReason) {
                logger.error("[#{}] {} failed on {}: {}", new Object[]{request.desc.parentSessionId, verb, from, failureReason});
                if (RepairMessage.supportsTimeouts(from, request.desc.parentSessionId)) {
                    failureCallback.onFailure(RepairException.error(request.desc, PreviewKind.NONE, String.format("Got %s failure from %s: %s", new Object[]{verb, from, failureReason})));
                }
            }
        };
        MessagingService.instance().sendWithCallback(Message.outWithFlag(verb, request, MessageFlag.CALL_BACK_ON_FAILURE), endpoint, callback);
    }

    private static boolean supportsTimeouts(InetAddressAndPort from, TimeUUID parentSessionId) {
        CassandraVersion remoteVersion = Gossiper.instance.getReleaseVersion(from);
        if (remoteVersion != null && remoteVersion.compareTo(SUPPORTS_TIMEOUTS) >= 0) {
            return true;
        }
        logger.warn("[#{}] Not failing repair due to remote host {} not supporting repair message timeouts (version = {})", new Object[]{parentSessionId, from, remoteVersion});
        return false;
    }

    public static interface RepairFailureCallback {
        public void onFailure(Exception var1);
    }
}

