/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair.consistent.admin;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.nmoncho.shaded.com.google.common.base.Preconditions;
import net.nmoncho.shaded.com.google.common.collect.Iterables;
import net.nmoncho.shaded.com.google.common.collect.Lists;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.schema.Schema;
import org.apache.cassandra.utils.AbstractIterator;

public class SchemaArgsParser
implements Iterable<ColumnFamilyStore> {
    private final List<String> schemaArgs;

    private SchemaArgsParser(List<String> schemaArgs) {
        this.schemaArgs = schemaArgs;
    }

    @Override
    public Iterator<ColumnFamilyStore> iterator() {
        if (this.schemaArgs.isEmpty()) {
            final Iterator ksNames = Schema.instance.distributedKeyspaces().names().iterator();
            return new AbstractIterator<ColumnFamilyStore>(){
                TableIterator current = null;

                @Override
                protected ColumnFamilyStore computeNext() {
                    while (true) {
                        if (this.current != null && this.current.hasNext()) {
                            return (ColumnFamilyStore)this.current.next();
                        }
                        if (!ksNames.hasNext()) break;
                        this.current = new TableIterator((String)ksNames.next(), Collections.emptyList());
                    }
                    return (ColumnFamilyStore)this.endOfData();
                }
            };
        }
        return new TableIterator(this.schemaArgs.get(0), this.schemaArgs.subList(1, this.schemaArgs.size()));
    }

    public static Iterable<ColumnFamilyStore> parse(List<String> schemaArgs) {
        return new SchemaArgsParser(schemaArgs);
    }

    public static Iterable<ColumnFamilyStore> parse(String ... schemaArgs) {
        return SchemaArgsParser.parse(Lists.newArrayList(schemaArgs));
    }

    private static class TableIterator
    extends AbstractIterator<ColumnFamilyStore> {
        private final Iterator<ColumnFamilyStore> tables;

        public TableIterator(String ksName, List<String> tableNames) {
            Preconditions.checkArgument(Schema.instance.getKeyspaceMetadata(ksName) != null);
            Keyspace keyspace = Keyspace.open(ksName);
            this.tables = tableNames.isEmpty() ? keyspace.getColumnFamilyStores().iterator() : Lists.newArrayList(Iterables.transform(tableNames, tn -> keyspace.getColumnFamilyStore((String)tn))).iterator();
        }

        @Override
        protected ColumnFamilyStore computeNext() {
            return this.tables.hasNext() ? this.tables.next() : (ColumnFamilyStore)this.endOfData();
        }
    }
}

