/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair.asymmetric;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.nmoncho.shaded.com.google.common.annotations.VisibleForTesting;
import net.nmoncho.shaded.com.google.common.collect.Sets;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.repair.asymmetric.DifferenceHolder;

public class StreamFromOptions {
    private final DifferenceHolder differences;
    @VisibleForTesting
    final Range<Token> range;
    private final Set<Set<InetAddressAndPort>> streamOptions = new HashSet<Set<InetAddressAndPort>>();

    public StreamFromOptions(DifferenceHolder differences, Range<Token> range) {
        this(differences, range, Collections.emptySet());
    }

    private StreamFromOptions(DifferenceHolder differences, Range<Token> range, Set<Set<InetAddressAndPort>> existing) {
        this.differences = differences;
        this.range = range;
        for (Set<InetAddressAndPort> addresses : existing) {
            this.streamOptions.add(Sets.newHashSet(addresses));
        }
    }

    public void add(InetAddressAndPort streamFromNode) {
        for (Set<InetAddressAndPort> options : this.streamOptions) {
            InetAddressAndPort first = options.iterator().next();
            if (this.differences.hasDifferenceBetween(first, streamFromNode, this.range)) continue;
            options.add(streamFromNode);
            return;
        }
        this.streamOptions.add(Sets.newHashSet(streamFromNode));
    }

    public StreamFromOptions copy(Range<Token> withRange) {
        return new StreamFromOptions(this.differences, withRange, this.streamOptions);
    }

    public Iterable<Set<InetAddressAndPort>> allStreams() {
        return this.streamOptions;
    }

    public String toString() {
        return "StreamFromOptions{, range=" + this.range + ", streamOptions=" + this.streamOptions + '}';
    }
}

