/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair.asymmetric;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import net.nmoncho.shaded.com.google.common.annotations.VisibleForTesting;
import net.nmoncho.shaded.com.google.common.collect.ImmutableMap;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.repair.asymmetric.DifferenceHolder;
import org.apache.cassandra.repair.asymmetric.HostDifferences;
import org.apache.cassandra.repair.asymmetric.IncomingRepairStreamTracker;
import org.apache.cassandra.repair.asymmetric.PreferedNodeFilter;
import org.apache.cassandra.repair.asymmetric.StreamFromOptions;

public class ReduceHelper {
    private static final Comparator<InetAddressAndPort> comparator = Comparator.comparing(InetAddressAndPort::getHostAddressAndPort);

    public static ImmutableMap<InetAddressAndPort, HostDifferences> reduce(DifferenceHolder differences, PreferedNodeFilter filter) {
        Map<InetAddressAndPort, IncomingRepairStreamTracker> trackers = ReduceHelper.createIncomingRepairStreamTrackers(differences);
        ImmutableMap.Builder<InetAddressAndPort, HostDifferences> mapBuilder = ImmutableMap.builder();
        for (Map.Entry<InetAddressAndPort, IncomingRepairStreamTracker> trackerEntry : trackers.entrySet()) {
            IncomingRepairStreamTracker tracker = trackerEntry.getValue();
            HostDifferences rangesToFetch = new HostDifferences();
            for (Map.Entry entry : tracker.getIncoming().entrySet()) {
                Range rangeToFetch = (Range)entry.getKey();
                for (InetAddressAndPort remoteNode : ReduceHelper.pickConsistent(trackerEntry.getKey(), (StreamFromOptions)entry.getValue(), filter)) {
                    rangesToFetch.addSingleRange(remoteNode, rangeToFetch);
                }
            }
            mapBuilder.put(trackerEntry.getKey(), rangesToFetch);
        }
        return mapBuilder.build();
    }

    @VisibleForTesting
    static Map<InetAddressAndPort, IncomingRepairStreamTracker> createIncomingRepairStreamTrackers(DifferenceHolder differences) {
        HashMap<InetAddressAndPort, IncomingRepairStreamTracker> trackers = new HashMap<InetAddressAndPort, IncomingRepairStreamTracker>();
        for (InetAddressAndPort hostWithDifference : differences.keyHosts()) {
            HostDifferences hostDifferences = differences.get(hostWithDifference);
            for (InetAddressAndPort differingHost : hostDifferences.hosts()) {
                NavigableSet<Range<Token>> differingRanges = hostDifferences.get(differingHost);
                for (Range range : differingRanges) {
                    ReduceHelper.getTracker(differences, trackers, hostWithDifference).addIncomingRangeFrom(range, differingHost);
                    ReduceHelper.getTracker(differences, trackers, differingHost).addIncomingRangeFrom(range, hostWithDifference);
                }
            }
        }
        return trackers;
    }

    private static IncomingRepairStreamTracker getTracker(DifferenceHolder differences, Map<InetAddressAndPort, IncomingRepairStreamTracker> trackers, InetAddressAndPort host) {
        return trackers.computeIfAbsent(host, h -> new IncomingRepairStreamTracker(differences));
    }

    private static Collection<InetAddressAndPort> pickConsistent(InetAddressAndPort streamingNode, StreamFromOptions toStreamFrom, PreferedNodeFilter filter) {
        HashSet<InetAddressAndPort> retSet = new HashSet<InetAddressAndPort>();
        for (Set<InetAddressAndPort> toStream : toStreamFrom.allStreams()) {
            ArrayList<InetAddressAndPort> toSearch = new ArrayList<InetAddressAndPort>(filter.apply(streamingNode, toStream));
            if (toSearch.isEmpty()) {
                toSearch = new ArrayList<InetAddressAndPort>(toStream);
            }
            toSearch.sort(comparator);
            int pos = Collections.binarySearch(toSearch, streamingNode, comparator);
            assert (pos < 0);
            if ((pos = -pos - 1) == toSearch.size()) {
                retSet.add((InetAddressAndPort)toSearch.get(0));
                continue;
            }
            retSet.add((InetAddressAndPort)toSearch.get(pos));
        }
        return retSet;
    }
}

