/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair.asymmetric;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.nmoncho.shaded.com.google.common.annotations.VisibleForTesting;
import net.nmoncho.shaded.com.google.common.collect.Sets;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.RingPosition;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.repair.asymmetric.RangeMap;
import org.apache.cassandra.repair.asymmetric.StreamFromOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangeDenormalizer {
    private static final Logger logger = LoggerFactory.getLogger(RangeDenormalizer.class);

    public static Set<Range<Token>> denormalize(Range<Token> range, RangeMap<StreamFromOptions> incoming) {
        logger.trace("Denormalizing range={} incoming={}", range, incoming);
        Set<Map.Entry<Range<Token>, StreamFromOptions>> existingOverlappingRanges = incoming.removeIntersecting(range);
        Set<Range<Token>> intersections = RangeDenormalizer.intersection(existingOverlappingRanges, range);
        Sets.SetView<Range<Token>> newExisting = Sets.union(RangeDenormalizer.subtractFromAllRanges(existingOverlappingRanges, range), intersections);
        Sets.SetView<Range<Token>> newInput = Sets.union(RangeDenormalizer.subtractAll(existingOverlappingRanges, range), intersections);
        for (Range range2 : newExisting) {
            for (Map.Entry<Range<Token>, StreamFromOptions> entry : existingOverlappingRanges) {
                if (!range2.intersects(entry.getKey())) continue;
                incoming.put(range2, entry.getValue().copy(range2));
            }
        }
        logger.trace("denormalized {} to {}", range, newInput);
        logger.trace("denormalized incoming to {}", incoming);
        return newInput;
    }

    @VisibleForTesting
    static Set<Range<Token>> subtractFromAllRanges(Collection<Map.Entry<Range<Token>, StreamFromOptions>> ranges, Range<Token> range) {
        HashSet<Range<Token>> result = new HashSet<Range<Token>>();
        for (Map.Entry<Range<Token>, StreamFromOptions> r : ranges) {
            result.addAll(r.getKey().subtract(range));
        }
        return result;
    }

    private static Set<Range<Token>> intersection(Set<Map.Entry<Range<Token>, StreamFromOptions>> ranges, Range<Token> range) {
        HashSet<Range<Token>> result = new HashSet<Range<Token>>();
        for (Map.Entry<Range<Token>, StreamFromOptions> r : ranges) {
            result.addAll(range.intersectionWith(r.getKey()));
        }
        return result;
    }

    public static Set<Range<Token>> subtractAll(Collection<Map.Entry<Range<Token>, StreamFromOptions>> ranges, Range<Token> toSubtract) {
        Set<Range<Object>> result = new HashSet();
        result.add(toSubtract);
        for (Map.Entry<Range<Token>, StreamFromOptions> range : ranges) {
            result = RangeDenormalizer.substractAllFromToken(result, range.getKey());
        }
        return result;
    }

    private static <T extends RingPosition<T>> Set<Range<T>> substractAllFromToken(Set<Range<T>> ranges, Range<T> subtract) {
        HashSet<Range<T>> result = new HashSet<Range<T>>();
        for (Range<T> range : ranges) {
            result.addAll(range.subtract(subtract));
        }
        return result;
    }
}

