/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair.asymmetric;

import java.util.List;
import java.util.Map;
import java.util.Set;
import net.nmoncho.shaded.com.google.common.annotations.VisibleForTesting;
import net.nmoncho.shaded.com.google.common.collect.ImmutableMap;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.repair.TreeResponse;
import org.apache.cassandra.repair.asymmetric.HostDifferences;
import org.apache.cassandra.utils.MerkleTrees;

public class DifferenceHolder {
    private final ImmutableMap<InetAddressAndPort, HostDifferences> differences;

    public DifferenceHolder(List<TreeResponse> trees) {
        ImmutableMap.Builder<InetAddressAndPort, HostDifferences> diffBuilder = ImmutableMap.builder();
        for (int i = 0; i < trees.size() - 1; ++i) {
            TreeResponse r1 = trees.get(i);
            HostDifferences hd = new HostDifferences();
            for (int j = i + 1; j < trees.size(); ++j) {
                TreeResponse r2 = trees.get(j);
                hd.add(r2.endpoint, MerkleTrees.difference(r1.trees, r2.trees));
            }
            r1.trees.release();
            diffBuilder.put(r1.endpoint, hd);
        }
        trees.get((int)(trees.size() - 1)).trees.release();
        this.differences = diffBuilder.build();
    }

    @VisibleForTesting
    DifferenceHolder(Map<InetAddressAndPort, HostDifferences> differences) {
        ImmutableMap.Builder<InetAddressAndPort, HostDifferences> diffBuilder = ImmutableMap.builder();
        diffBuilder.putAll(differences);
        this.differences = diffBuilder.build();
    }

    public Set<InetAddressAndPort> keyHosts() {
        return this.differences.keySet();
    }

    public HostDifferences get(InetAddressAndPort hostWithDifference) {
        return this.differences.get(hostWithDifference);
    }

    public String toString() {
        return "DifferenceHolder{differences=" + this.differences + '}';
    }

    public boolean hasDifferenceBetween(InetAddressAndPort node1, InetAddressAndPort node2, Range<Token> range) {
        HostDifferences diffsNode1 = this.differences.get(node1);
        if (diffsNode1 != null && diffsNode1.hasDifferencesFor(node2, range)) {
            return true;
        }
        HostDifferences diffsNode2 = this.differences.get(node2);
        return diffsNode2 != null && diffsNode2.hasDifferencesFor(node1, range);
    }
}

