/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.nmoncho.shaded.com.google.common.collect.Lists;
import net.nmoncho.shaded.com.google.common.util.concurrent.FutureCallback;
import org.apache.cassandra.concurrent.ExecutorPlus;
import org.apache.cassandra.repair.CommonRange;
import org.apache.cassandra.repair.CoordinatedRepairResult;
import org.apache.cassandra.repair.RepairNotifier;
import org.apache.cassandra.repair.RepairSession;
import org.apache.cassandra.repair.RepairSessionResult;
import org.apache.cassandra.repair.RepairTask;
import org.apache.cassandra.repair.Scheduler;
import org.apache.cassandra.repair.messages.RepairOption;
import org.apache.cassandra.service.ActiveRepairService;
import org.apache.cassandra.utils.TimeUUID;
import org.apache.cassandra.utils.concurrent.Future;
import org.apache.cassandra.utils.concurrent.FutureCombiner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRepairTask
implements RepairTask {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractRepairTask.class);
    protected final RepairOption options;
    protected final String keyspace;
    protected final RepairNotifier notifier;

    protected AbstractRepairTask(RepairOption options, String keyspace, RepairNotifier notifier) {
        this.options = Objects.requireNonNull(options);
        this.keyspace = Objects.requireNonNull(keyspace);
        this.notifier = Objects.requireNonNull(notifier);
    }

    private List<RepairSession> submitRepairSessions(TimeUUID parentSession, boolean isIncremental, ExecutorPlus executor, Scheduler validationScheduler, List<CommonRange> commonRanges, String ... cfnames) {
        ArrayList<RepairSession> futures = new ArrayList<RepairSession>(this.options.getRanges().size());
        for (CommonRange commonRange : commonRanges) {
            logger.info("Starting RepairSession for {}", (Object)commonRange);
            RepairSession session = ActiveRepairService.instance.submitRepairSession(parentSession, commonRange, this.keyspace, this.options.getParallelism(), isIncremental, this.options.isPullRepair(), this.options.getPreviewKind(), this.options.optimiseStreams(), this.options.repairPaxos(), this.options.paxosOnly(), executor, validationScheduler, cfnames);
            if (session == null) continue;
            session.addCallback((FutureCallback)new RepairSessionCallback(session));
            futures.add(session);
        }
        return futures;
    }

    protected Future<CoordinatedRepairResult> runRepair(TimeUUID parentSession, boolean isIncremental, ExecutorPlus executor, Scheduler validationScheduler, List<CommonRange> commonRanges, String ... cfnames) {
        List<RepairSession> allSessions = this.submitRepairSessions(parentSession, isIncremental, executor, validationScheduler, commonRanges, cfnames);
        List ranges = Lists.transform(allSessions, RepairSession::ranges);
        Future<List<List>> f = FutureCombiner.successfulOf(allSessions);
        return f.map(results -> {
            logger.debug("Repair result: {}", results);
            return CoordinatedRepairResult.create(ranges, results);
        });
    }

    private class RepairSessionCallback
    implements FutureCallback<RepairSessionResult> {
        private final RepairSession session;

        public RepairSessionCallback(RepairSession session) {
            this.session = session;
        }

        @Override
        public void onSuccess(RepairSessionResult result) {
            String message = String.format("Repair session %s for range %s finished", this.session.getId(), this.session.ranges().toString());
            AbstractRepairTask.this.notifier.notifyProgress(message);
        }

        @Override
        public void onFailure(Throwable t) {
            String message = String.format("Repair session %s for range %s failed with error %s", this.session.getId(), this.session.ranges().toString(), t.getMessage());
            AbstractRepairTask.this.notifier.notifyError(new RuntimeException(message, t));
        }
    }
}

