/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import java.nio.channels.FileChannel;
import java.util.concurrent.atomic.AtomicInteger;
import net.nmoncho.shaded.io.netty.channel.DefaultFileRegion;
import org.apache.cassandra.utils.concurrent.Ref;
import org.apache.cassandra.utils.concurrent.RefCounted;

public class SharedDefaultFileRegion
extends DefaultFileRegion {
    private final SharedFileChannel shared;
    private boolean deallocated = false;

    SharedDefaultFileRegion(SharedFileChannel shared, long position, long count) {
        super(shared.ref.get(), position, count);
        this.shared = shared;
        if (1 >= this.shared.refCount.incrementAndGet()) {
            throw new IllegalStateException();
        }
    }

    protected void deallocate() {
        if (this.deallocated) {
            return;
        }
        this.deallocated = true;
        this.shared.release();
    }

    public static SharedFileChannel share(FileChannel fileChannel) {
        return new SharedFileChannel(fileChannel);
    }

    public static class SharedFileChannel {
        final Ref<FileChannel> ref;
        final AtomicInteger refCount = new AtomicInteger(1);

        SharedFileChannel(final FileChannel fileChannel) {
            this.ref = new Ref<FileChannel>(fileChannel, new RefCounted.Tidy(){

                @Override
                public void tidy() throws Exception {
                    fileChannel.close();
                }

                @Override
                public String name() {
                    return "SharedFileChannel[" + fileChannel.toString() + ']';
                }
            });
        }

        public void release() {
            if (0 == this.refCount.decrementAndGet()) {
                this.ref.release();
            }
        }
    }
}

