/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import net.nmoncho.shaded.com.google.common.annotations.VisibleForTesting;
import net.nmoncho.shaded.com.google.common.base.Preconditions;
import net.nmoncho.shaded.io.netty.channel.WriteBufferWaterMark;
import org.apache.cassandra.auth.IInternodeAuthenticator;
import org.apache.cassandra.config.Config;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.EncryptionOptions;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.locator.IEndpointSnitch;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.net.AcceptVersions;
import org.apache.cassandra.net.ConnectionCategory;
import org.apache.cassandra.net.EndpointMessagingVersions;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.net.OutboundDebugCallbacks;
import org.apache.cassandra.net.OutboundMessageCallbacks;
import org.apache.cassandra.net.ResourceLimits;
import org.apache.cassandra.net.SocketFactory;
import org.apache.cassandra.utils.FBUtilities;

public class OutboundConnectionSettings {
    private static final String INTRADC_TCP_NODELAY_PROPERTY = "cassandra.otc_intradc_tcp_nodelay";
    private static final boolean INTRADC_TCP_NODELAY = Boolean.parseBoolean(System.getProperty("cassandra.otc_intradc_tcp_nodelay", "true"));
    public final IInternodeAuthenticator authenticator;
    public final InetAddressAndPort to;
    public final InetAddressAndPort connectTo;
    public final EncryptionOptions encryption;
    public final Framing framing;
    public final Integer socketSendBufferSizeInBytes;
    public final Integer applicationSendQueueCapacityInBytes;
    public final Integer applicationSendQueueReserveEndpointCapacityInBytes;
    public final ResourceLimits.Limit applicationSendQueueReserveGlobalCapacityInBytes;
    public final Boolean tcpNoDelay;
    public final int flushLowWaterMark;
    public final int flushHighWaterMark;
    public final Integer tcpConnectTimeoutInMS;
    public final Integer tcpUserTimeoutInMS;
    public final AcceptVersions acceptVersions;
    public final InetAddressAndPort from;
    public final SocketFactory socketFactory;
    public final OutboundMessageCallbacks callbacks;
    public final OutboundDebugCallbacks debug;
    public final EndpointMessagingVersions endpointToVersion;

    public OutboundConnectionSettings(InetAddressAndPort to) {
        this(to, null);
    }

    public OutboundConnectionSettings(InetAddressAndPort to, InetAddressAndPort preferred) {
        this(null, to, preferred, null, null, null, null, null, null, null, 32768, 65536, null, null, null, null, null, null, null, null);
    }

    private OutboundConnectionSettings(IInternodeAuthenticator authenticator, InetAddressAndPort to, InetAddressAndPort connectTo, EncryptionOptions encryption, Framing framing, Integer socketSendBufferSizeInBytes, Integer applicationSendQueueCapacityInBytes, Integer applicationSendQueueReserveEndpointCapacityInBytes, ResourceLimits.Limit applicationSendQueueReserveGlobalCapacityInBytes, Boolean tcpNoDelay, int flushLowWaterMark, int flushHighWaterMark, Integer tcpConnectTimeoutInMS, Integer tcpUserTimeoutInMS, AcceptVersions acceptVersions, InetAddressAndPort from, SocketFactory socketFactory, OutboundMessageCallbacks callbacks, OutboundDebugCallbacks debug, EndpointMessagingVersions endpointToVersion) {
        Preconditions.checkArgument(socketSendBufferSizeInBytes == null || socketSendBufferSizeInBytes == 0 || socketSendBufferSizeInBytes >= 1024, "illegal socket send buffer size: " + socketSendBufferSizeInBytes);
        Preconditions.checkArgument(applicationSendQueueCapacityInBytes == null || applicationSendQueueCapacityInBytes >= 1024, "illegal application send queue capacity: " + applicationSendQueueCapacityInBytes);
        Preconditions.checkArgument(tcpUserTimeoutInMS == null || tcpUserTimeoutInMS >= 0, "tcp user timeout must be non negative: " + tcpUserTimeoutInMS);
        Preconditions.checkArgument(tcpConnectTimeoutInMS == null || tcpConnectTimeoutInMS > 0, "tcp connect timeout must be positive: " + tcpConnectTimeoutInMS);
        this.authenticator = authenticator;
        this.to = to;
        this.connectTo = connectTo;
        this.encryption = encryption;
        this.framing = framing;
        this.socketSendBufferSizeInBytes = socketSendBufferSizeInBytes;
        this.applicationSendQueueCapacityInBytes = applicationSendQueueCapacityInBytes;
        this.applicationSendQueueReserveEndpointCapacityInBytes = applicationSendQueueReserveEndpointCapacityInBytes;
        this.applicationSendQueueReserveGlobalCapacityInBytes = applicationSendQueueReserveGlobalCapacityInBytes;
        this.tcpNoDelay = tcpNoDelay;
        this.flushLowWaterMark = flushLowWaterMark;
        this.flushHighWaterMark = flushHighWaterMark;
        this.tcpConnectTimeoutInMS = tcpConnectTimeoutInMS;
        this.tcpUserTimeoutInMS = tcpUserTimeoutInMS;
        this.acceptVersions = acceptVersions;
        this.from = from;
        this.socketFactory = socketFactory;
        this.callbacks = callbacks;
        this.debug = debug;
        this.endpointToVersion = endpointToVersion;
    }

    public boolean authenticate() {
        return this.authenticator.authenticate(this.to.getAddress(), this.to.getPort());
    }

    public boolean withEncryption() {
        return this.encryption != null;
    }

    public String toString() {
        return String.format("peer: (%s, %s), framing: %s, encryption: %s", new Object[]{this.to, this.connectTo, this.framing, SocketFactory.encryptionOptionsSummary(this.encryption)});
    }

    public OutboundConnectionSettings withAuthenticator(IInternodeAuthenticator authenticator) {
        return new OutboundConnectionSettings(authenticator, this.to, this.connectTo, this.encryption, this.framing, this.socketSendBufferSizeInBytes, this.applicationSendQueueCapacityInBytes, this.applicationSendQueueReserveEndpointCapacityInBytes, this.applicationSendQueueReserveGlobalCapacityInBytes, this.tcpNoDelay, this.flushLowWaterMark, this.flushHighWaterMark, this.tcpConnectTimeoutInMS, this.tcpUserTimeoutInMS, this.acceptVersions, this.from, this.socketFactory, this.callbacks, this.debug, this.endpointToVersion);
    }

    public OutboundConnectionSettings toEndpoint(InetAddressAndPort endpoint) {
        return new OutboundConnectionSettings(this.authenticator, endpoint, this.connectTo, this.encryption, this.framing, this.socketSendBufferSizeInBytes, this.applicationSendQueueCapacityInBytes, this.applicationSendQueueReserveEndpointCapacityInBytes, this.applicationSendQueueReserveGlobalCapacityInBytes, this.tcpNoDelay, this.flushLowWaterMark, this.flushHighWaterMark, this.tcpConnectTimeoutInMS, this.tcpUserTimeoutInMS, this.acceptVersions, this.from, this.socketFactory, this.callbacks, this.debug, this.endpointToVersion);
    }

    public OutboundConnectionSettings withConnectTo(InetAddressAndPort connectTo) {
        return new OutboundConnectionSettings(this.authenticator, this.to, connectTo, this.encryption, this.framing, this.socketSendBufferSizeInBytes, this.applicationSendQueueCapacityInBytes, this.applicationSendQueueReserveEndpointCapacityInBytes, this.applicationSendQueueReserveGlobalCapacityInBytes, this.tcpNoDelay, this.flushLowWaterMark, this.flushHighWaterMark, this.tcpConnectTimeoutInMS, this.tcpUserTimeoutInMS, this.acceptVersions, this.from, this.socketFactory, this.callbacks, this.debug, this.endpointToVersion);
    }

    public OutboundConnectionSettings withEncryption(EncryptionOptions.ServerEncryptionOptions encryption) {
        return new OutboundConnectionSettings(this.authenticator, this.to, this.connectTo, encryption, this.framing, this.socketSendBufferSizeInBytes, this.applicationSendQueueCapacityInBytes, this.applicationSendQueueReserveEndpointCapacityInBytes, this.applicationSendQueueReserveGlobalCapacityInBytes, this.tcpNoDelay, this.flushLowWaterMark, this.flushHighWaterMark, this.tcpConnectTimeoutInMS, this.tcpUserTimeoutInMS, this.acceptVersions, this.from, this.socketFactory, this.callbacks, this.debug, this.endpointToVersion);
    }

    public OutboundConnectionSettings withFraming(Framing framing) {
        return new OutboundConnectionSettings(this.authenticator, this.to, this.connectTo, this.encryption, framing, this.socketSendBufferSizeInBytes, this.applicationSendQueueCapacityInBytes, this.applicationSendQueueReserveEndpointCapacityInBytes, this.applicationSendQueueReserveGlobalCapacityInBytes, this.tcpNoDelay, this.flushLowWaterMark, this.flushHighWaterMark, this.tcpConnectTimeoutInMS, this.tcpUserTimeoutInMS, this.acceptVersions, this.from, this.socketFactory, this.callbacks, this.debug, this.endpointToVersion);
    }

    public OutboundConnectionSettings withSocketSendBufferSizeInBytes(int socketSendBufferSizeInBytes) {
        return new OutboundConnectionSettings(this.authenticator, this.to, this.connectTo, this.encryption, this.framing, socketSendBufferSizeInBytes, this.applicationSendQueueCapacityInBytes, this.applicationSendQueueReserveEndpointCapacityInBytes, this.applicationSendQueueReserveGlobalCapacityInBytes, this.tcpNoDelay, this.flushLowWaterMark, this.flushHighWaterMark, this.tcpConnectTimeoutInMS, this.tcpUserTimeoutInMS, this.acceptVersions, this.from, this.socketFactory, this.callbacks, this.debug, this.endpointToVersion);
    }

    public OutboundConnectionSettings withApplicationSendQueueCapacityInBytes(int applicationSendQueueCapacityInBytes) {
        return new OutboundConnectionSettings(this.authenticator, this.to, this.connectTo, this.encryption, this.framing, this.socketSendBufferSizeInBytes, applicationSendQueueCapacityInBytes, this.applicationSendQueueReserveEndpointCapacityInBytes, this.applicationSendQueueReserveGlobalCapacityInBytes, this.tcpNoDelay, this.flushLowWaterMark, this.flushHighWaterMark, this.tcpConnectTimeoutInMS, this.tcpUserTimeoutInMS, this.acceptVersions, this.from, this.socketFactory, this.callbacks, this.debug, this.endpointToVersion);
    }

    public OutboundConnectionSettings withApplicationReserveSendQueueCapacityInBytes(Integer applicationReserveSendQueueEndpointCapacityInBytes, ResourceLimits.Limit applicationReserveSendQueueGlobalCapacityInBytes) {
        return new OutboundConnectionSettings(this.authenticator, this.to, this.connectTo, this.encryption, this.framing, this.socketSendBufferSizeInBytes, this.applicationSendQueueCapacityInBytes, applicationReserveSendQueueEndpointCapacityInBytes, applicationReserveSendQueueGlobalCapacityInBytes, this.tcpNoDelay, this.flushLowWaterMark, this.flushHighWaterMark, this.tcpConnectTimeoutInMS, this.tcpUserTimeoutInMS, this.acceptVersions, this.from, this.socketFactory, this.callbacks, this.debug, this.endpointToVersion);
    }

    public OutboundConnectionSettings withTcpNoDelay(boolean tcpNoDelay) {
        return new OutboundConnectionSettings(this.authenticator, this.to, this.connectTo, this.encryption, this.framing, this.socketSendBufferSizeInBytes, this.applicationSendQueueCapacityInBytes, this.applicationSendQueueReserveEndpointCapacityInBytes, this.applicationSendQueueReserveGlobalCapacityInBytes, tcpNoDelay, this.flushLowWaterMark, this.flushHighWaterMark, this.tcpConnectTimeoutInMS, this.tcpUserTimeoutInMS, this.acceptVersions, this.from, this.socketFactory, this.callbacks, this.debug, this.endpointToVersion);
    }

    public OutboundConnectionSettings withNettyBufferBounds(WriteBufferWaterMark nettyBufferBounds) {
        return new OutboundConnectionSettings(this.authenticator, this.to, this.connectTo, this.encryption, this.framing, this.socketSendBufferSizeInBytes, this.applicationSendQueueCapacityInBytes, this.applicationSendQueueReserveEndpointCapacityInBytes, this.applicationSendQueueReserveGlobalCapacityInBytes, this.tcpNoDelay, this.flushLowWaterMark, this.flushHighWaterMark, this.tcpConnectTimeoutInMS, this.tcpUserTimeoutInMS, this.acceptVersions, this.from, this.socketFactory, this.callbacks, this.debug, this.endpointToVersion);
    }

    public OutboundConnectionSettings withTcpConnectTimeoutInMS(int tcpConnectTimeoutInMS) {
        return new OutboundConnectionSettings(this.authenticator, this.to, this.connectTo, this.encryption, this.framing, this.socketSendBufferSizeInBytes, this.applicationSendQueueCapacityInBytes, this.applicationSendQueueReserveEndpointCapacityInBytes, this.applicationSendQueueReserveGlobalCapacityInBytes, this.tcpNoDelay, this.flushLowWaterMark, this.flushHighWaterMark, tcpConnectTimeoutInMS, this.tcpUserTimeoutInMS, this.acceptVersions, this.from, this.socketFactory, this.callbacks, this.debug, this.endpointToVersion);
    }

    public OutboundConnectionSettings withTcpUserTimeoutInMS(int tcpUserTimeoutInMS) {
        return new OutboundConnectionSettings(this.authenticator, this.to, this.connectTo, this.encryption, this.framing, this.socketSendBufferSizeInBytes, this.applicationSendQueueCapacityInBytes, this.applicationSendQueueReserveEndpointCapacityInBytes, this.applicationSendQueueReserveGlobalCapacityInBytes, this.tcpNoDelay, this.flushLowWaterMark, this.flushHighWaterMark, this.tcpConnectTimeoutInMS, tcpUserTimeoutInMS, this.acceptVersions, this.from, this.socketFactory, this.callbacks, this.debug, this.endpointToVersion);
    }

    public OutboundConnectionSettings withAcceptVersions(AcceptVersions acceptVersions) {
        return new OutboundConnectionSettings(this.authenticator, this.to, this.connectTo, this.encryption, this.framing, this.socketSendBufferSizeInBytes, this.applicationSendQueueCapacityInBytes, this.applicationSendQueueReserveEndpointCapacityInBytes, this.applicationSendQueueReserveGlobalCapacityInBytes, this.tcpNoDelay, this.flushLowWaterMark, this.flushHighWaterMark, this.tcpConnectTimeoutInMS, this.tcpUserTimeoutInMS, acceptVersions, this.from, this.socketFactory, this.callbacks, this.debug, this.endpointToVersion);
    }

    public OutboundConnectionSettings withFrom(InetAddressAndPort from) {
        return new OutboundConnectionSettings(this.authenticator, this.to, this.connectTo, this.encryption, this.framing, this.socketSendBufferSizeInBytes, this.applicationSendQueueCapacityInBytes, this.applicationSendQueueReserveEndpointCapacityInBytes, this.applicationSendQueueReserveGlobalCapacityInBytes, this.tcpNoDelay, this.flushLowWaterMark, this.flushHighWaterMark, this.tcpConnectTimeoutInMS, this.tcpUserTimeoutInMS, this.acceptVersions, from, this.socketFactory, this.callbacks, this.debug, this.endpointToVersion);
    }

    public OutboundConnectionSettings withSocketFactory(SocketFactory socketFactory) {
        return new OutboundConnectionSettings(this.authenticator, this.to, this.connectTo, this.encryption, this.framing, this.socketSendBufferSizeInBytes, this.applicationSendQueueCapacityInBytes, this.applicationSendQueueReserveEndpointCapacityInBytes, this.applicationSendQueueReserveGlobalCapacityInBytes, this.tcpNoDelay, this.flushLowWaterMark, this.flushHighWaterMark, this.tcpConnectTimeoutInMS, this.tcpUserTimeoutInMS, this.acceptVersions, this.from, socketFactory, this.callbacks, this.debug, this.endpointToVersion);
    }

    public OutboundConnectionSettings withCallbacks(OutboundMessageCallbacks callbacks) {
        return new OutboundConnectionSettings(this.authenticator, this.to, this.connectTo, this.encryption, this.framing, this.socketSendBufferSizeInBytes, this.applicationSendQueueCapacityInBytes, this.applicationSendQueueReserveEndpointCapacityInBytes, this.applicationSendQueueReserveGlobalCapacityInBytes, this.tcpNoDelay, this.flushLowWaterMark, this.flushHighWaterMark, this.tcpConnectTimeoutInMS, this.tcpUserTimeoutInMS, this.acceptVersions, this.from, this.socketFactory, callbacks, this.debug, this.endpointToVersion);
    }

    public OutboundConnectionSettings withDebugCallbacks(OutboundDebugCallbacks debug) {
        return new OutboundConnectionSettings(this.authenticator, this.to, this.connectTo, this.encryption, this.framing, this.socketSendBufferSizeInBytes, this.applicationSendQueueCapacityInBytes, this.applicationSendQueueReserveEndpointCapacityInBytes, this.applicationSendQueueReserveGlobalCapacityInBytes, this.tcpNoDelay, this.flushLowWaterMark, this.flushHighWaterMark, this.tcpConnectTimeoutInMS, this.tcpUserTimeoutInMS, this.acceptVersions, this.from, this.socketFactory, this.callbacks, debug, this.endpointToVersion);
    }

    public OutboundConnectionSettings withDefaultReserveLimits() {
        Integer applicationReserveSendQueueEndpointCapacityInBytes = this.applicationSendQueueReserveEndpointCapacityInBytes;
        ResourceLimits.Limit applicationReserveSendQueueGlobalCapacityInBytes = this.applicationSendQueueReserveGlobalCapacityInBytes;
        if (applicationReserveSendQueueEndpointCapacityInBytes == null) {
            applicationReserveSendQueueEndpointCapacityInBytes = DatabaseDescriptor.getInternodeApplicationSendQueueReserveEndpointCapacityInBytes();
        }
        if (applicationReserveSendQueueGlobalCapacityInBytes == null) {
            applicationReserveSendQueueGlobalCapacityInBytes = MessagingService.instance().outboundGlobalReserveLimit;
        }
        return this.withApplicationReserveSendQueueCapacityInBytes(applicationReserveSendQueueEndpointCapacityInBytes, applicationReserveSendQueueGlobalCapacityInBytes);
    }

    public IInternodeAuthenticator authenticator() {
        return this.authenticator != null ? this.authenticator : DatabaseDescriptor.getInternodeAuthenticator();
    }

    public EndpointMessagingVersions endpointToVersion() {
        if (this.endpointToVersion == null) {
            return MessagingService.instance().versions;
        }
        return this.endpointToVersion;
    }

    public InetAddressAndPort from() {
        return this.from != null ? this.from : FBUtilities.getBroadcastAddressAndPort();
    }

    public OutboundDebugCallbacks debug() {
        return this.debug != null ? this.debug : OutboundDebugCallbacks.NONE;
    }

    public EncryptionOptions encryption() {
        return this.encryption != null ? this.encryption : OutboundConnectionSettings.defaultEncryptionOptions(this.to);
    }

    public SocketFactory socketFactory() {
        return this.socketFactory != null ? this.socketFactory : MessagingService.instance().socketFactory;
    }

    public OutboundMessageCallbacks callbacks() {
        return this.callbacks != null ? this.callbacks : MessagingService.instance().callbacks;
    }

    public int socketSendBufferSizeInBytes() {
        return this.socketSendBufferSizeInBytes != null ? this.socketSendBufferSizeInBytes : DatabaseDescriptor.getInternodeSocketSendBufferSizeInBytes();
    }

    public int applicationSendQueueCapacityInBytes() {
        return this.applicationSendQueueCapacityInBytes != null ? this.applicationSendQueueCapacityInBytes : DatabaseDescriptor.getInternodeApplicationSendQueueCapacityInBytes();
    }

    public ResourceLimits.Limit applicationSendQueueReserveGlobalCapacityInBytes() {
        return this.applicationSendQueueReserveGlobalCapacityInBytes != null ? this.applicationSendQueueReserveGlobalCapacityInBytes : MessagingService.instance().outboundGlobalReserveLimit;
    }

    public int applicationSendQueueReserveEndpointCapacityInBytes() {
        return this.applicationSendQueueReserveEndpointCapacityInBytes != null ? this.applicationSendQueueReserveEndpointCapacityInBytes : DatabaseDescriptor.getInternodeApplicationReceiveQueueReserveEndpointCapacityInBytes();
    }

    public int tcpConnectTimeoutInMS() {
        return this.tcpConnectTimeoutInMS != null ? this.tcpConnectTimeoutInMS : DatabaseDescriptor.getInternodeTcpConnectTimeoutInMS();
    }

    public int tcpUserTimeoutInMS(ConnectionCategory category) {
        if (this.tcpUserTimeoutInMS != null) {
            return this.tcpUserTimeoutInMS;
        }
        switch (category) {
            case MESSAGING: {
                return DatabaseDescriptor.getInternodeTcpUserTimeoutInMS();
            }
            case STREAMING: {
                return DatabaseDescriptor.getInternodeStreamingTcpUserTimeoutInMS();
            }
        }
        throw new IllegalArgumentException("Unknown connection category: " + (Object)((Object)category));
    }

    public boolean tcpNoDelay() {
        if (this.tcpNoDelay != null) {
            return this.tcpNoDelay;
        }
        if (OutboundConnectionSettings.isInLocalDC(DatabaseDescriptor.getEndpointSnitch(), FBUtilities.getBroadcastAddressAndPort(), this.to)) {
            return INTRADC_TCP_NODELAY;
        }
        return DatabaseDescriptor.getInterDCTcpNoDelay();
    }

    public AcceptVersions acceptVersions(ConnectionCategory category) {
        return this.acceptVersions != null ? this.acceptVersions : (category.isStreaming() ? MessagingService.accept_streaming : MessagingService.accept_messaging);
    }

    public OutboundConnectionSettings withLegacyPortIfNecessary(int messagingVersion) {
        return this.withConnectTo(OutboundConnectionSettings.maybeWithSecurePort(this.connectTo(), messagingVersion, this.withEncryption()));
    }

    public InetAddressAndPort connectTo() {
        InetAddressAndPort connectTo = this.connectTo;
        if (connectTo == null) {
            connectTo = SystemKeyspace.getPreferredIP(this.to);
        }
        if (FBUtilities.getBroadcastAddressAndPort().equals(connectTo)) {
            return FBUtilities.getLocalAddressAndPort();
        }
        return connectTo;
    }

    public String connectToId() {
        return !this.to.equals(this.connectTo()) ? this.to.toString() : this.to.toString() + '(' + this.connectTo().toString() + ')';
    }

    public Framing framing(ConnectionCategory category) {
        if (this.framing != null) {
            return this.framing;
        }
        if (category.isStreaming()) {
            return Framing.UNPROTECTED;
        }
        return OutboundConnectionSettings.shouldCompressConnection(DatabaseDescriptor.getEndpointSnitch(), FBUtilities.getBroadcastAddressAndPort(), this.to) ? Framing.LZ4 : Framing.CRC;
    }

    public OutboundConnectionSettings withDefaults(ConnectionCategory category) {
        if (this.to == null) {
            throw new IllegalArgumentException();
        }
        return new OutboundConnectionSettings(this.authenticator(), this.to, this.connectTo(), this.encryption(), this.framing(category), this.socketSendBufferSizeInBytes(), this.applicationSendQueueCapacityInBytes(), this.applicationSendQueueReserveEndpointCapacityInBytes(), this.applicationSendQueueReserveGlobalCapacityInBytes(), this.tcpNoDelay(), this.flushLowWaterMark, this.flushHighWaterMark, this.tcpConnectTimeoutInMS(), this.tcpUserTimeoutInMS(category), this.acceptVersions(category), this.from(), this.socketFactory(), this.callbacks(), this.debug(), this.endpointToVersion());
    }

    private static boolean isInLocalDC(IEndpointSnitch snitch, InetAddressAndPort localHost, InetAddressAndPort remoteHost) {
        String remoteDC = snitch.getDatacenter(remoteHost);
        String localDC = snitch.getDatacenter(localHost);
        return remoteDC != null && remoteDC.equals(localDC);
    }

    @VisibleForTesting
    static EncryptionOptions defaultEncryptionOptions(InetAddressAndPort endpoint) {
        EncryptionOptions.ServerEncryptionOptions options = DatabaseDescriptor.getInternodeMessagingEncyptionOptions();
        return options.shouldEncrypt(endpoint) ? options : null;
    }

    @VisibleForTesting
    static boolean shouldCompressConnection(IEndpointSnitch snitch, InetAddressAndPort localHost, InetAddressAndPort remoteHost) {
        return DatabaseDescriptor.internodeCompression() == Config.InternodeCompression.all || DatabaseDescriptor.internodeCompression() == Config.InternodeCompression.dc && !OutboundConnectionSettings.isInLocalDC(snitch, localHost, remoteHost);
    }

    private static InetAddressAndPort maybeWithSecurePort(InetAddressAndPort address, int messagingVersion, boolean isEncrypted) {
        if (!isEncrypted || messagingVersion >= 12) {
            return address;
        }
        return address.withPort(DatabaseDescriptor.getSSLStoragePort());
    }

    public static enum Framing {
        UNPROTECTED(0),
        LZ4(1),
        CRC(2);

        final int id;

        public static Framing forId(int id) {
            switch (id) {
                case 0: {
                    return UNPROTECTED;
                }
                case 1: {
                    return LZ4;
                }
                case 2: {
                    return CRC;
                }
            }
            throw new IllegalStateException();
        }

        private Framing(int id) {
            this.id = id;
        }
    }
}

