/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import java.nio.ByteBuffer;
import net.nmoncho.shaded.io.netty.buffer.ByteBuf;
import net.nmoncho.shaded.io.netty.channel.ChannelHandler;
import org.apache.cassandra.net.FrameEncoder;
import org.apache.cassandra.net.FrameEncoderCrc;
import org.apache.cassandra.net.GlobalBufferPoolAllocator;

@ChannelHandler.Sharable
class FrameEncoderUnprotected
extends FrameEncoder {
    static final FrameEncoderUnprotected instance = new FrameEncoderUnprotected();
    static final FrameEncoder.PayloadAllocator allocator = (isSelfContained, capacity) -> new FrameEncoder.Payload(isSelfContained, capacity, 6, 0);

    FrameEncoderUnprotected() {
    }

    @Override
    public FrameEncoder.PayloadAllocator allocator() {
        return allocator;
    }

    @Override
    ByteBuf encode(boolean isSelfContained, ByteBuffer frame) {
        try {
            int frameLength = frame.remaining();
            int dataLength = frameLength - 6;
            if (dataLength >= 131072) {
                throw new IllegalArgumentException("Maximum uncompressed payload size is 128KiB");
            }
            FrameEncoderCrc.writeHeader(frame, isSelfContained, dataLength);
            return GlobalBufferPoolAllocator.wrap(frame);
        }
        catch (Throwable t) {
            bufferPool.put(frame);
            throw t;
        }
    }
}

