/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import java.nio.ByteBuffer;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.xxhash.XXHash32;
import net.jpountz.xxhash.XXHashFactory;
import net.nmoncho.shaded.io.netty.buffer.ByteBuf;
import net.nmoncho.shaded.io.netty.channel.ChannelHandler;
import org.apache.cassandra.io.compress.BufferType;
import org.apache.cassandra.net.FrameEncoder;
import org.apache.cassandra.net.GlobalBufferPoolAllocator;
import org.apache.cassandra.utils.ByteBufferUtil;

@ChannelHandler.Sharable
class FrameEncoderLegacyLZ4
extends FrameEncoder {
    static final FrameEncoderLegacyLZ4 instance = new FrameEncoderLegacyLZ4(XXHashFactory.fastestInstance().hash32(), LZ4Factory.fastestInstance().fastCompressor());
    private final XXHash32 xxhash;
    private final LZ4Compressor compressor;
    private static final byte TOKEN_NON_COMPRESSED = 21;
    private static final byte TOKEN_COMPRESSED = 37;

    private FrameEncoderLegacyLZ4(XXHash32 xxhash, LZ4Compressor compressor) {
        this.xxhash = xxhash;
        this.compressor = compressor;
    }

    @Override
    ByteBuf encode(boolean isSelfContained, ByteBuffer payload) {
        ByteBuffer frame = null;
        try {
            int blockLength;
            frame = bufferPool.getAtLeast(this.calculateMaxFrameLength(payload), BufferType.OFF_HEAP);
            int frameOffset = 0;
            int payloadLength = payload.remaining();
            for (int payloadOffset = 0; payloadOffset < payloadLength; payloadOffset += blockLength) {
                blockLength = Math.min(32768, payloadLength - payloadOffset);
                frameOffset += this.compressBlock(frame, frameOffset, payload, payloadOffset, blockLength);
            }
            frame.limit(frameOffset);
            bufferPool.putUnusedPortion(frame);
            ByteBuf byteBuf = GlobalBufferPoolAllocator.wrap(frame);
            return byteBuf;
        }
        catch (Throwable t) {
            if (null != frame) {
                bufferPool.put(frame);
            }
            throw t;
        }
        finally {
            bufferPool.put(payload);
        }
    }

    private int compressBlock(ByteBuffer frame, int frameOffset, ByteBuffer payload, int payloadOffset, int blockLength) {
        int frameBytesRemaining = frame.limit() - (frameOffset + 21);
        int compressedLength = this.compressor.compress(payload, payloadOffset, blockLength, frame, frameOffset + 21, frameBytesRemaining);
        if (compressedLength >= blockLength) {
            ByteBufferUtil.copyBytes(payload, payloadOffset, frame, frameOffset + 21, blockLength);
            compressedLength = blockLength;
        }
        int checksum = this.xxhash.hash(payload, payloadOffset, blockLength, -1756908916) & 0xFFFFFFF;
        FrameEncoderLegacyLZ4.writeHeader(frame, frameOffset, compressedLength, blockLength, checksum);
        return 21 + compressedLength;
    }

    private static void writeHeader(ByteBuffer frame, int frameOffset, int compressedLength, int uncompressedLength, int checksum) {
        byte token = compressedLength == uncompressedLength ? (byte)21 : 37;
        frame.putLong(frameOffset + 0, 5501767354678207339L);
        frame.put(frameOffset + 8, token);
        frame.putInt(frameOffset + 9, Integer.reverseBytes(compressedLength));
        frame.putInt(frameOffset + 13, Integer.reverseBytes(uncompressedLength));
        frame.putInt(frameOffset + 17, Integer.reverseBytes(checksum));
    }

    private int calculateMaxFrameLength(ByteBuffer payload) {
        int payloadLength = payload.remaining();
        int blockCount = payloadLength / 32768 + (payloadLength % 32768 != 0 ? 1 : 0);
        return this.compressor.maxCompressedLength(payloadLength) + 21 * blockCount;
    }
}

