/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import java.nio.ByteBuffer;
import java.util.Collection;
import net.nmoncho.shaded.io.netty.channel.ChannelHandler;
import net.nmoncho.shaded.io.netty.channel.ChannelPipeline;
import org.apache.cassandra.net.BufferPoolAllocator;
import org.apache.cassandra.net.FrameDecoder;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.OutboundConnections;
import org.apache.cassandra.net.ShareableBytes;

class FrameDecoderLegacy
extends FrameDecoder {
    private final int messagingVersion;
    private int remainingBytesInLargeMessage = 0;

    FrameDecoderLegacy(BufferPoolAllocator allocator, int messagingVersion) {
        super(allocator);
        this.messagingVersion = messagingVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    final void decode(Collection<FrameDecoder.Frame> into, ShareableBytes newBytes) {
        ByteBuffer in = newBytes.get();
        try {
            int length;
            int begin;
            if (this.stash != null) {
                boolean isSelfContained;
                int length2 = Message.serializer.inferMessageSize(this.stash, 0, this.stash.position(), this.messagingVersion);
                while (length2 < 0) {
                    if (!in.hasRemaining()) {
                        return;
                    }
                    if (this.stash.position() == this.stash.capacity()) {
                        this.stash = this.ensureCapacity(this.stash, this.stash.capacity() * 2);
                    }
                    FrameDecoderLegacy.copyToSize(in, this.stash, this.stash.capacity());
                    length2 = Message.serializer.inferMessageSize(this.stash, 0, this.stash.position(), this.messagingVersion);
                    if (length2 < 0 || length2 >= this.stash.position()) continue;
                    int excess = this.stash.position() - length2;
                    in.position(in.position() - excess);
                    this.stash.position(length2);
                }
                if (length2 <= OutboundConnections.LARGE_MESSAGE_THRESHOLD) {
                    isSelfContained = true;
                    if (length2 > this.stash.capacity()) {
                        this.stash = this.ensureCapacity(this.stash, length2);
                    }
                    this.stash.limit(length2);
                    this.allocator.putUnusedPortion(this.stash);
                    if (!FrameDecoderLegacy.copyToSize(in, this.stash, length2)) {
                        return;
                    }
                } else {
                    isSelfContained = false;
                    this.remainingBytesInLargeMessage = length2 - this.stash.position();
                    this.stash.limit(this.stash.position());
                    this.allocator.putUnusedPortion(this.stash);
                }
                this.stash.flip();
                assert (!isSelfContained || this.stash.limit() == length2);
                ShareableBytes stashed = ShareableBytes.wrap(this.stash);
                into.add(new FrameDecoder.IntactFrame(isSelfContained, stashed));
                this.stash = null;
            }
            if (this.remainingBytesInLargeMessage > 0) {
                if (this.remainingBytesInLargeMessage >= newBytes.remaining()) {
                    this.remainingBytesInLargeMessage -= newBytes.remaining();
                    into.add(new FrameDecoder.IntactFrame(false, newBytes.sliceAndConsume(newBytes.remaining())));
                    return;
                }
                FrameDecoder.IntactFrame frame = new FrameDecoder.IntactFrame(false, newBytes.sliceAndConsume(this.remainingBytesInLargeMessage));
                this.remainingBytesInLargeMessage = 0;
                into.add(frame);
            }
            int end = begin = in.position();
            int limit = in.limit();
            if (begin == limit) {
                return;
            }
            while ((length = Message.serializer.inferMessageSize(in, end, limit, this.messagingVersion)) >= 0 && end + length <= limit) {
                if ((end += length) < limit) continue;
                length = 0;
                break;
            }
            if (begin < end) {
                into.add(new FrameDecoder.IntactFrame(true, newBytes.slice(begin, end)));
            }
            if (length < 0) {
                this.stash(newBytes, Math.max(64, limit - end), end, limit - end);
            } else if (length > OutboundConnections.LARGE_MESSAGE_THRESHOLD) {
                this.remainingBytesInLargeMessage = length - (limit - end);
                FrameDecoder.IntactFrame frame = new FrameDecoder.IntactFrame(false, newBytes.slice(end, limit));
                into.add(frame);
            } else if (length > 0) {
                this.stash(newBytes, length, end, limit - end);
            }
        }
        catch (Message.InvalidLegacyProtocolMagic e) {
            into.add(FrameDecoder.CorruptFrame.unrecoverable(e.read, -900387334));
        }
        finally {
            newBytes.release();
        }
    }

    @Override
    void addLastTo(ChannelPipeline pipeline) {
        pipeline.addLast("frameDecoderNone", (ChannelHandler)this);
    }
}

