/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.zip.CRC32;
import net.nmoncho.shaded.io.netty.buffer.ByteBuf;
import net.nmoncho.shaded.io.netty.util.concurrent.FastThreadLocal;

public class Crc {
    private static final FastThreadLocal<CRC32> crc32 = new FastThreadLocal<CRC32>(){

        protected CRC32 initialValue() {
            return new CRC32();
        }
    };
    private static final byte[] initialBytes = new byte[]{-6, 45, 85, -54};
    private static final int CRC24_INIT = 8867936;
    private static final int CRC24_POLY = 26693387;

    public static CRC32 crc32() {
        CRC32 crc = (CRC32)crc32.get();
        crc.reset();
        crc.update(initialBytes);
        return crc;
    }

    static int computeCrc32(ByteBuf buffer, int startReaderIndex, int endReaderIndex) {
        CRC32 crc = Crc.crc32();
        crc.update(buffer.internalNioBuffer(startReaderIndex, endReaderIndex - startReaderIndex));
        return (int)crc.getValue();
    }

    static int computeCrc32(ByteBuffer buffer, int start, int end) {
        CRC32 crc = Crc.crc32();
        Crc.updateCrc32(crc, buffer, start, end);
        return (int)crc.getValue();
    }

    static void updateCrc32(CRC32 crc, ByteBuffer buffer, int start, int end) {
        int savePosition = buffer.position();
        int saveLimit = buffer.limit();
        buffer.limit(end);
        buffer.position(start);
        crc.update(buffer);
        buffer.limit(saveLimit);
        buffer.position(savePosition);
    }

    static int crc24(long bytes, int len) {
        int crc = 8867936;
        while (len-- > 0) {
            crc = (int)((long)crc ^ (bytes & 0xFFL) << 16);
            bytes >>= 8;
            for (int i = 0; i < 8; ++i) {
                if (((crc <<= 1) & 0x1000000) == 0) continue;
                crc ^= 0x1974F0B;
            }
        }
        return crc;
    }

    public static final class InvalidCrc
    extends IOException {
        public InvalidCrc(int read, int computed) {
            super(String.format("Read %d, Computed %d", read, computed));
        }
    }
}

