/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import java.io.EOFException;
import net.nmoncho.shaded.com.google.common.collect.Iterators;
import net.nmoncho.shaded.com.google.common.collect.PeekingIterator;
import org.apache.cassandra.io.util.RebufferingInputStream;
import org.apache.cassandra.net.ShareableBytes;

class ChunkedInputPlus
extends RebufferingInputStream {
    private final PeekingIterator<ShareableBytes> iter;

    private ChunkedInputPlus(PeekingIterator<ShareableBytes> iter) {
        super(iter.peek().get());
        this.iter = iter;
    }

    static ChunkedInputPlus of(Iterable<ShareableBytes> buffers) {
        PeekingIterator<ShareableBytes> iter = Iterators.peekingIterator(buffers.iterator());
        if (!iter.hasNext()) {
            throw new IllegalArgumentException();
        }
        return new ChunkedInputPlus(iter);
    }

    @Override
    protected void reBuffer() throws EOFException {
        this.buffer = null;
        this.iter.peek().release();
        this.iter.next();
        if (!this.iter.hasNext()) {
            throw new EOFException();
        }
        this.buffer = this.iter.peek().get();
    }

    @Override
    public void close() {
        this.buffer = null;
        this.iter.forEachRemaining(ShareableBytes::release);
    }

    int remainder() {
        this.buffer = null;
        int bytes = 0;
        while (this.iter.hasNext()) {
            ShareableBytes chunk = this.iter.peek();
            bytes += chunk.remaining();
            chunk.release();
            this.iter.next();
        }
        return bytes;
    }
}

