/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.nmoncho.shaded.com.google.common.collect.MinMaxPriorityQueue;
import org.apache.cassandra.metrics.Sampler;

public abstract class MaxSampler<T>
extends Sampler<T> {
    private int capacity;
    private MinMaxPriorityQueue<Sampler.Sample<T>> queue;
    private long endTimeNanos = -1L;
    private final Comparator<Sampler.Sample<T>> comp = Collections.reverseOrder(Comparator.comparing(p -> p.count));

    @Override
    public boolean isEnabled() {
        return this.endTimeNanos != -1L && this.clock.now() <= this.endTimeNanos;
    }

    @Override
    public synchronized void beginSampling(int capacity, int durationMillis) {
        if (this.endTimeNanos != -1L && this.clock.now() <= this.endTimeNanos) {
            throw new RuntimeException("Sampling already in progress");
        }
        this.endTimeNanos = this.clock.now() + TimeUnit.MILLISECONDS.toNanos(durationMillis);
        this.queue = MinMaxPriorityQueue.orderedBy(this.comp).maximumSize(Math.max(1, capacity)).create();
        this.capacity = capacity;
    }

    @Override
    public synchronized List<Sampler.Sample<T>> finishSampling(int count) {
        ArrayList<Sampler.Sample<T>> result = new ArrayList<Sampler.Sample<T>>(count);
        if (this.endTimeNanos != -1L) {
            Sampler.Sample<T> next;
            this.endTimeNanos = -1L;
            while ((next = this.queue.poll()) != null && result.size() <= count) {
                result.add(next);
            }
        }
        return result;
    }

    @Override
    protected synchronized void insert(T item, long value) {
        if (value > 0L && this.clock.now() <= this.endTimeNanos && (this.queue.isEmpty() || this.queue.size() < this.capacity || this.queue.peekLast().count < value)) {
            this.queue.add(new Sampler.Sample<T>(item, value, 0L));
        }
    }
}

