/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.nmoncho.shaded.com.google.common.collect.Collections2;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.locator.EndpointsForRange;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.locator.Replica;

public class SystemReplicas {
    private static final Map<InetAddressAndPort, Replica> systemReplicas = new ConcurrentHashMap<InetAddressAndPort, Replica>();
    public static final Range<Token> FULL_RANGE = new Range<Token>(DatabaseDescriptor.getPartitioner().getMinimumToken(), DatabaseDescriptor.getPartitioner().getMinimumToken());

    private static Replica createSystemReplica(InetAddressAndPort endpoint) {
        return new Replica(endpoint, FULL_RANGE, true);
    }

    public static Replica getSystemReplica(InetAddressAndPort endpoint) {
        return systemReplicas.computeIfAbsent(endpoint, SystemReplicas::createSystemReplica);
    }

    public static EndpointsForRange getSystemReplicas(Collection<InetAddressAndPort> endpoints) {
        if (endpoints.isEmpty()) {
            return EndpointsForRange.empty(FULL_RANGE);
        }
        return EndpointsForRange.copyOf(Collections2.transform(endpoints, SystemReplicas::getSystemReplica));
    }
}

