/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import java.util.Set;
import java.util.function.Predicate;
import net.nmoncho.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.RingPosition;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.gms.FailureDetector;
import org.apache.cassandra.locator.AbstractReplicationStrategy;
import org.apache.cassandra.locator.Endpoints;
import org.apache.cassandra.locator.EndpointsForRange;
import org.apache.cassandra.locator.EndpointsForToken;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.locator.Replica;
import org.apache.cassandra.utils.FBUtilities;

public abstract class ReplicaLayout<E extends Endpoints<E>> {
    private final E natural;
    private final AbstractReplicationStrategy replicationStrategy;

    ReplicaLayout(AbstractReplicationStrategy replicationStrategy, E natural) {
        this.replicationStrategy = replicationStrategy;
        this.natural = natural;
    }

    public final E natural() {
        return this.natural;
    }

    public final AbstractReplicationStrategy replicationStrategy() {
        return this.replicationStrategy;
    }

    public E all() {
        return this.natural;
    }

    public String toString() {
        return "ReplicaLayout [ natural: " + this.natural + " ]";
    }

    public static ForTokenWrite forTokenWriteLiveAndDown(Keyspace keyspace, Token token) {
        AbstractReplicationStrategy replicationStrategy = keyspace.getReplicationStrategy();
        EndpointsForToken natural = EndpointsForToken.natural(replicationStrategy, token);
        EndpointsForToken pending = EndpointsForToken.pending(keyspace, token);
        return ReplicaLayout.forTokenWrite(replicationStrategy, natural, pending);
    }

    public static ForTokenWrite forTokenWrite(AbstractReplicationStrategy replicationStrategy, EndpointsForToken natural, EndpointsForToken pending) {
        if (ReplicaLayout.haveWriteConflicts(natural, pending)) {
            natural = ReplicaLayout.resolveWriteConflictsInNatural(natural, pending);
            pending = ReplicaLayout.resolveWriteConflictsInPending(natural, pending);
        }
        return new ForTokenWrite(replicationStrategy, natural, pending);
    }

    static <E extends Endpoints<E>> boolean haveWriteConflicts(E natural, E pending) {
        Set<InetAddressAndPort> naturalEndpoints = natural.endpoints();
        for (InetAddressAndPort pendingEndpoint : pending.endpoints()) {
            if (!naturalEndpoints.contains(pendingEndpoint)) continue;
            return true;
        }
        return false;
    }

    @VisibleForTesting
    static EndpointsForToken resolveWriteConflictsInNatural(EndpointsForToken natural, EndpointsForToken pending) {
        EndpointsForToken.Builder resolved = natural.newBuilder(natural.size());
        for (Replica replica : natural) {
            Replica conflict;
            if (replica.isTransient() && (conflict = pending.byEndpoint().get(replica.endpoint())) != null) {
                assert (conflict.isFull());
                resolved.add(conflict);
                continue;
            }
            resolved.add(replica);
        }
        return resolved.build();
    }

    @VisibleForTesting
    static EndpointsForToken resolveWriteConflictsInPending(EndpointsForToken natural, EndpointsForToken pending) {
        return (EndpointsForToken)pending.without(natural.endpoints());
    }

    public static ForTokenRead forTokenReadLiveSorted(AbstractReplicationStrategy replicationStrategy, Token token) {
        EndpointsForToken replicas = replicationStrategy.getNaturalReplicasForToken(token);
        replicas = DatabaseDescriptor.getEndpointSnitch().sortedByProximity(FBUtilities.getBroadcastAddressAndPort(), replicas);
        replicas = (EndpointsForToken)replicas.filter(FailureDetector.isReplicaAlive);
        return new ForTokenRead(replicationStrategy, replicas);
    }

    static ForRangeRead forRangeReadLiveSorted(AbstractReplicationStrategy replicationStrategy, AbstractBounds<PartitionPosition> range) {
        EndpointsForRange replicas = replicationStrategy.getNaturalReplicas((RingPosition<?>)range.right);
        replicas = DatabaseDescriptor.getEndpointSnitch().sortedByProximity(FBUtilities.getBroadcastAddressAndPort(), replicas);
        replicas = (EndpointsForRange)replicas.filter(FailureDetector.isReplicaAlive);
        return new ForRangeRead(replicationStrategy, range, replicas);
    }

    public static interface ForToken {
        public Token token();
    }

    public static interface ForRange {
        public AbstractBounds<PartitionPosition> range();
    }

    public static class ForTokenWrite
    extends ForWrite<EndpointsForToken>
    implements ForToken {
        public ForTokenWrite(AbstractReplicationStrategy replicationStrategy, EndpointsForToken natural, EndpointsForToken pending) {
            this(replicationStrategy, natural, pending, null);
        }

        public ForTokenWrite(AbstractReplicationStrategy replicationStrategy, EndpointsForToken natural, EndpointsForToken pending, EndpointsForToken all) {
            super(replicationStrategy, natural, pending, all);
        }

        @Override
        public Token token() {
            return ((EndpointsForToken)this.natural()).token();
        }

        public ForTokenWrite filter(Predicate<Replica> filter) {
            EndpointsForToken filtered = (EndpointsForToken)((EndpointsForToken)this.all()).filter(filter);
            if (filtered == this.all()) {
                return this;
            }
            if (((EndpointsForToken)this.pending()).isEmpty()) {
                return new ForTokenWrite(this.replicationStrategy(), filtered, (EndpointsForToken)this.pending(), filtered);
            }
            return new ForTokenWrite(this.replicationStrategy(), (EndpointsForToken)((EndpointsForToken)this.natural()).keep(filtered.endpoints()), (EndpointsForToken)((EndpointsForToken)this.pending()).keep(filtered.endpoints()), filtered);
        }
    }

    public static class ForWrite<E extends Endpoints<E>>
    extends ReplicaLayout<E> {
        final E all;
        final E pending;

        ForWrite(AbstractReplicationStrategy replicationStrategy, E natural, E pending, E all) {
            super(replicationStrategy, natural);
            assert (pending != null && !ForWrite.haveWriteConflicts(natural, pending));
            if (all == null) {
                all = Endpoints.concat(natural, pending);
            }
            this.all = all;
            this.pending = pending;
        }

        @Override
        public final E all() {
            return this.all;
        }

        public final E pending() {
            return this.pending;
        }

        @Override
        public String toString() {
            return "ReplicaLayout [ natural: " + this.natural() + ", pending: " + this.pending + " ]";
        }
    }

    public static class ForRangeRead
    extends ReplicaLayout<EndpointsForRange>
    implements ForRange {
        final AbstractBounds<PartitionPosition> range;

        public ForRangeRead(AbstractReplicationStrategy replicationStrategy, AbstractBounds<PartitionPosition> range, EndpointsForRange natural) {
            super(replicationStrategy, natural);
            this.range = range;
        }

        @Override
        public AbstractBounds<PartitionPosition> range() {
            return this.range;
        }

        public ForRangeRead filter(Predicate<Replica> filter) {
            EndpointsForRange filtered = (EndpointsForRange)((EndpointsForRange)this.natural()).filter(filter);
            if (filtered == this.natural()) {
                return this;
            }
            return new ForRangeRead(this.replicationStrategy(), this.range(), filtered);
        }
    }

    public static class ForTokenRead
    extends ReplicaLayout<EndpointsForToken>
    implements ForToken {
        public ForTokenRead(AbstractReplicationStrategy replicationStrategy, EndpointsForToken natural) {
            super(replicationStrategy, natural);
        }

        @Override
        public Token token() {
            return ((EndpointsForToken)this.natural()).token();
        }

        public ForTokenRead filter(Predicate<Replica> filter) {
            EndpointsForToken filtered = (EndpointsForToken)((EndpointsForToken)this.natural()).filter(filter);
            if (filtered == this.natural()) {
                return this;
            }
            return new ForTokenRead(this.replicationStrategy(), filtered);
        }
    }
}

